/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;

final class MethodRef {
    private final Class<?> targetClass;
    private final String methodName;

    private MethodRef(Class<?> targetClass, String methodName) {
        this.targetClass = targetClass;
        this.methodName = methodName;
    }

    static MethodRef from(Serializable methodRef) {
        try {
            Class<?> methodRefClass = methodRef.getClass();
            Method replaceMethod = methodRefClass.getDeclaredMethod("writeReplace", new Class[0]);
            replaceMethod.setAccessible(true);
            SerializedLambda lambda = (SerializedLambda)replaceMethod.invoke((Object)methodRef, new Object[0]);
            String className = lambda.getImplClass().replace('/', '.');
            ClassLoader classLoader = ObjectUtils.defaultIfNull(methodRefClass.getClassLoader(), MethodRef.class.getClassLoader());
            Class<?> targetClass = Class.forName(className, true, classLoader);
            String implMethodName = lambda.getImplMethodName();
            return new MethodRef(targetClass, implMethodName);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw Fail.withUsageError("unable to resolve method name from selector", ex);
        }
    }

    Class<?> getTargetClass() {
        return this.targetClass;
    }

    String getMethodName() {
        return this.methodName;
    }
}

