/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.instancio.Random;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.hints.MapHint;
import org.instancio.generator.specs.MapGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.ErrorHandler;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.util.ExceptionUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.NumberUtils;
import org.instancio.settings.Keys;

public class MapGenerator<K, V>
extends AbstractGenerator<Map<K, V>>
implements MapGeneratorSpec<K, V> {
    private static final Class<?> DEFAULT_MAP_TYPE = HashMap.class;
    protected int minSize;
    protected int maxSize;
    private boolean nullableKeys;
    private boolean nullableValues;
    protected Class<?> mapType;
    private Map<K, V> withEntries;
    private List<K> withKeys;

    public MapGenerator(GeneratorContext context) {
        super(context);
        this.minSize = context.getSettings().get(Keys.MAP_MIN_SIZE);
        this.maxSize = context.getSettings().get(Keys.MAP_MAX_SIZE);
        super.nullable(context.getSettings().get(Keys.MAP_NULLABLE));
        this.nullableKeys = context.getSettings().get(Keys.MAP_KEYS_NULLABLE);
        this.nullableValues = context.getSettings().get(Keys.MAP_VALUES_NULLABLE);
        this.mapType = DEFAULT_MAP_TYPE;
    }

    @Override
    public String apiMethod() {
        return "map()";
    }

    @Override
    public MapGenerator<K, V> subtype(Class<?> type) {
        this.mapType = ApiValidator.notNull(type, "type must not be null", new Object[0]);
        return this;
    }

    @Override
    public MapGenerator<K, V> size(int size) {
        this.minSize = ApiValidator.validateSize(size);
        this.maxSize = size;
        return this;
    }

    @Override
    public MapGenerator<K, V> minSize(int size) {
        this.minSize = ApiValidator.validateSize(size);
        this.maxSize = NumberUtils.calculateNewMaxSize(this.maxSize, this.minSize);
        return this;
    }

    @Override
    public MapGenerator<K, V> maxSize(int size) {
        this.maxSize = ApiValidator.validateSize(size);
        this.minSize = NumberUtils.calculateNewMinSize(this.minSize, this.maxSize);
        return this;
    }

    @Override
    public MapGenerator<K, V> nullable() {
        super.nullable();
        return this;
    }

    public MapGenerator<K, V> nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    public MapGenerator<K, V> nullableKeys() {
        this.nullableKeys = true;
        return this;
    }

    @Override
    public MapGenerator<K, V> nullableValues() {
        this.nullableValues = true;
        return this;
    }

    @Override
    public MapGenerator<K, V> with(K key, V value) {
        if (this.withEntries == null) {
            this.withEntries = new HashMap();
        }
        this.withEntries.put(key, value);
        return this;
    }

    @Override
    @SafeVarargs
    public final MapGenerator<K, V> withKeys(K ... keys) {
        ApiValidator.notEmpty(keys, "'map().withKeys(...)' must contain at least one key", new Object[0]);
        if (this.withKeys == null) {
            this.withKeys = new ArrayList<K>();
        }
        this.withKeys.addAll(Arrays.asList(keys));
        return this;
    }

    @Override
    public Map<K, V> tryGenerateNonNull(Random random) {
        try {
            return (Map)this.mapType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            String msg = String.format("Error creating instance of: %s", this.mapType);
            if (ErrorHandler.shouldFailOnError(this.getContext().getSettings())) {
                throw Fail.withFataInternalError(msg, ex);
            }
            ExceptionUtils.logException(msg, ex, new Object[0]);
            return null;
        }
    }

    @Override
    public Hints hints() {
        return Hints.builder().afterGenerate(AfterGenerate.POPULATE_ALL).with(MapHint.builder().generateEntries(this.getContext().random().intRange(this.minSize, this.maxSize)).nullableMapKeys(this.nullableKeys).nullableMapValues(this.nullableValues).withEntries(this.withEntries).withKeys(this.withKeys).build()).with(InternalGeneratorHint.builder().targetClass(this.mapType).delegating(this.isDelegating()).nullableResult(this.isNullable()).build()).build();
    }
}

