/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.YearMonth;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.YearMonthSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.util.Constants;
import org.instancio.support.Global;

public class YearMonthGenerator
extends JavaTimeTemporalGenerator<YearMonth>
implements YearMonthSpec {
    static final YearMonth DEFAULT_MIN = YearMonth.from(Constants.DEFAULT_MIN.toLocalDate());
    static final YearMonth DEFAULT_MAX = YearMonth.from(Constants.DEFAULT_MAX.toLocalDate());

    public YearMonthGenerator() {
        this(Global.generatorContext());
    }

    public YearMonthGenerator(GeneratorContext context) {
        super(context, DEFAULT_MIN, DEFAULT_MAX);
    }

    @Override
    public String apiMethod() {
        return "yearMonth()";
    }

    @Override
    public YearMonthGenerator past() {
        super.past();
        return this;
    }

    @Override
    public YearMonthGenerator future() {
        super.future();
        return this;
    }

    @Override
    public YearMonthGenerator range(YearMonth start, YearMonth end) {
        super.range(start, end);
        return this;
    }

    @Override
    public YearMonthGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    YearMonth getLatestPast() {
        return YearMonth.now().minusMonths(1L);
    }

    @Override
    YearMonth getEarliestFuture() {
        return YearMonth.now().plusMonths(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.validateStartEnd((YearMonth)this.min, (YearMonth)this.max);
    }

    @Override
    protected YearMonth tryGenerateNonNull(Random random) {
        int minMonth = ((YearMonth)this.min).getYear() * 12 + ((YearMonth)this.min).getMonthValue() - 1;
        int maxMonth = ((YearMonth)this.max).getYear() * 12 + ((YearMonth)this.max).getMonthValue() - 1;
        int result = random.intRange(minMonth, maxMonth);
        int year = result / 12;
        int month = result - year * 12 + 1;
        return YearMonth.of(year, month);
    }
}

