/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.util.List;
import java.util.Optional;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.Hints;
import org.instancio.generator.specs.SubtypeGeneratorSpec;
import org.instancio.generators.Generators;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.GeneratorResolverMaps;
import org.instancio.internal.generator.GeneratorUtil;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.lang.EnumGenerator;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.Keys;
import org.instancio.spi.InstancioServiceProvider;
import org.instancio.spi.InstancioSpiException;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorResolver {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorResolver.class);
    private final GeneratorContext context;
    private final Generators generators;
    private final List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> providerEntries;
    private final AfterGenerate afterGenerate;

    public GeneratorResolver(GeneratorContext context, List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> providerEntries) {
        this.context = context;
        this.generators = new Generators(context);
        this.afterGenerate = context.getSettings().get(Keys.AFTER_GENERATE_HINT);
        this.providerEntries = providerEntries;
    }

    private static Generator<?> loadByClassName(GeneratorContext context, String generatorClassName) {
        Class<?> generatorClass = ReflectionUtils.loadClass(generatorClassName);
        return GeneratorUtil.instantiateInternalGenerator(generatorClass, context);
    }

    public Optional<Generator<?>> get(InternalNode node) {
        Class<?> klass = node.getTargetClass();
        Generator<?> spiGenerator = this.getSpiGenerator(node);
        if (spiGenerator != null) {
            return Optional.of(spiGenerator);
        }
        Generator<?> generator = this.getBuiltInGenerator(klass);
        if (generator == null) {
            generator = klass.isArray() ? new ArrayGenerator(this.context, klass) : (klass.isEnum() ? new EnumGenerator(this.context, klass) : this.getGeneratorForLegacyClass(klass));
        }
        return Optional.ofNullable(generator);
    }

    @Nullable
    private Generator<?> getGeneratorForLegacyClass(Class<?> klass) {
        if ("java.sql.Date".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "org.instancio.internal.generator.sql.SqlDateGenerator");
        }
        if ("java.sql.Timestamp".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "org.instancio.internal.generator.sql.TimestampGenerator");
        }
        if ("javax.xml.datatype.XMLGregorianCalendar".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "org.instancio.internal.generator.xml.XMLGregorianCalendarGenerator");
        }
        return null;
    }

    private Generator<?> getBuiltInGenerator(Class<?> targetClass) {
        Class<?> subtype;
        Class<?> genClass = GeneratorResolverMaps.getGenerator(targetClass);
        if (genClass == null) {
            return null;
        }
        Generator generator = GeneratorUtil.instantiateInternalGenerator(genClass, this.context);
        if (generator instanceof SubtypeGeneratorSpec && (subtype = GeneratorResolverMaps.getSubtype(targetClass)) != null) {
            ((SubtypeGeneratorSpec)((Object)generator)).subtype(subtype);
        }
        return generator;
    }

    private Generator<?> getSpiGenerator(InternalNode node) {
        for (ProviderEntry<InstancioServiceProvider.GeneratorProvider> entry : this.providerEntries) {
            GeneratorSpec<?> spec = entry.getProvider().getGenerator(node, this.generators);
            if (spec == null) continue;
            GeneratorResolver.validateSpec(entry, spec);
            LOG.trace("Custom generator '{}' found for {}", (Object)spec.getClass().getName(), (Object)node);
            Generator<?> generator = this.processGenerator((Generator)spec, node);
            generator.init(this.context);
            return GeneratorDecorator.decorateIfNullAfterGenerate(generator, this.afterGenerate);
        }
        return null;
    }

    private static void validateSpec(ProviderEntry<InstancioServiceProvider.GeneratorProvider> entry, GeneratorSpec<?> spec) {
        if (spec instanceof Generator) {
            return;
        }
        throw new InstancioSpiException(String.format("The GeneratorSpec %s returned by %s must implement %s", spec.getClass(), entry.getInstancioProviderClass(), Generator.class));
    }

    private Generator<?> processGenerator(Generator<?> generator, InternalNode node) {
        if (generator instanceof ArrayGenerator) {
            ((ArrayGenerator)generator).subtype((Class)node.getTargetClass());
        } else if (generator instanceof AbstractGenerator) {
            AbstractGenerator g = (AbstractGenerator)generator;
            if (!g.isDelegating()) {
                return g;
            }
            Hints hints = generator.hints();
            InternalGeneratorHint internalHint = hints.get(InternalGeneratorHint.class);
            Generator<?> delegate = this.getBuiltInGenerator(ObjectUtils.defaultIfNull(internalHint.targetClass(), node.getTargetClass()));
            if (delegate == null) {
                return generator;
            }
            if (delegate instanceof AbstractGenerator) {
                boolean nullable = ((AbstractGenerator)generator).isNullable();
                ((AbstractGenerator)delegate).nullable(nullable);
            }
            return GeneratorDecorator.replaceHints(delegate, hints);
        }
        return generator;
    }
}

