/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.ArrayDeque;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.instancio.TargetSelector;
import org.instancio.internal.context.ApiMethodSelector;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.nodes.InternalNode;

final class SelectorNodeMatchesCollector {
    private final SelectorMap<?> ignoredSelectorMap;
    private final SelectorMap<?> nullableSelectorMap;
    private final SelectorMap<?> onCompleteCallbackSelectorMap;
    private final SelectorMap<?> subtypeSelectorMap;
    private final SelectorMap<?> generatorSelectorMap;
    private final SelectorMap<?> assignmentOriginSelectorMap;
    private final SelectorMap<?> assignmentDestinationSelectorMap;

    private SelectorNodeMatchesCollector(Builder builder) {
        this.ignoredSelectorMap = builder.ignoredSelectorMap;
        this.nullableSelectorMap = builder.nullableSelectorMap;
        this.onCompleteCallbackSelectorMap = builder.onCompleteCallbackSelectorMap;
        this.subtypeSelectorMap = builder.subtypeSelectorMap;
        this.generatorSelectorMap = builder.generatorSelectorMap;
        this.assignmentOriginSelectorMap = builder.assignmentOriginSelectorMap;
        this.assignmentDestinationSelectorMap = builder.assignmentDestinationSelectorMap;
    }

    public Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> getNodeMatches(InternalNode rootNode) {
        EnumMap<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> map = new EnumMap<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>>(ApiMethodSelector.class);
        ArrayDeque<InternalNode> queue = new ArrayDeque<InternalNode>();
        queue.offer(rootNode);
        while (!queue.isEmpty()) {
            InternalNode node = (InternalNode)queue.poll();
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.IGNORE, node, this.ignoredSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.WITH_NULLABLE, node, this.nullableSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.ON_COMPLETE, node, this.onCompleteCallbackSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.SUBTYPE, node, this.subtypeSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.GENERATE, node, this.generatorSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.ASSIGN_ORIGIN, node, this.assignmentOriginSelectorMap);
            SelectorNodeMatchesCollector.collectNodes(map, ApiMethodSelector.ASSIGN_DESTINATION, node, this.assignmentDestinationSelectorMap);
            queue.addAll(node.getChildren());
        }
        return map;
    }

    private static void collectNodes(Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> resultsMap, ApiMethodSelector method, InternalNode node, SelectorMap<?> selectorMap) {
        Map selectorNodeMap = resultsMap.computeIfAbsent(method, k -> new LinkedHashMap());
        Set<TargetSelector> selectors = selectorMap.getSelectors(node);
        selectors.forEach(selector -> {
            Set nodes = selectorNodeMap.computeIfAbsent(selector, k -> new LinkedHashSet());
            nodes.add(node);
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SelectorMap<?> ignoredSelectorMap;
        private SelectorMap<?> nullableSelectorMap;
        private SelectorMap<?> onCompleteCallbackSelectorMap;
        private SelectorMap<?> subtypeSelectorMap;
        private SelectorMap<?> generatorSelectorMap;
        private SelectorMap<?> assignmentOriginSelectorMap;
        private SelectorMap<?> assignmentDestinationSelectorMap;

        private Builder() {
        }

        public Builder ignoredSelectorMap(SelectorMap<?> ignoredSelectorMap) {
            this.ignoredSelectorMap = ignoredSelectorMap;
            return this;
        }

        public Builder nullableSelectorMap(SelectorMap<?> nullableSelectorMap) {
            this.nullableSelectorMap = nullableSelectorMap;
            return this;
        }

        public Builder onCompleteCallbackSelectorMap(SelectorMap<?> onCompleteCallbackSelectorMap) {
            this.onCompleteCallbackSelectorMap = onCompleteCallbackSelectorMap;
            return this;
        }

        public Builder subtypeSelectorMap(SelectorMap<?> subtypeSelectorMap) {
            this.subtypeSelectorMap = subtypeSelectorMap;
            return this;
        }

        public Builder generatorSelectorMap(SelectorMap<?> generatorSelectorMap) {
            this.generatorSelectorMap = generatorSelectorMap;
            return this;
        }

        public Builder assignmentOriginSelectorMap(SelectorMap<?> assignmentOriginSelectorMap) {
            this.assignmentOriginSelectorMap = assignmentOriginSelectorMap;
            return this;
        }

        public Builder assignmentDestinationSelectorMap(SelectorMap<?> assignmentDestinationSelectorMap) {
            this.assignmentDestinationSelectorMap = assignmentDestinationSelectorMap;
            return this;
        }

        public SelectorNodeMatchesCollector build() {
            return new SelectorNodeMatchesCollector(this);
        }
    }
}

