/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.instancio.PredicateSelector;
import org.instancio.Scope;
import org.instancio.TargetSelector;
import org.instancio.internal.PrimitiveWrapperBiLookup;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SortedSetWithReverseInsertionOrder;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.selectors.PredicateScopeImpl;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.PrimitiveAndWrapperSelectorImpl;
import org.instancio.internal.selectors.ScopeImpl;
import org.instancio.internal.selectors.ScopelessSelector;
import org.instancio.internal.selectors.SelectorImpl;
import org.instancio.internal.selectors.Target;
import org.instancio.internal.selectors.TargetClass;
import org.instancio.internal.selectors.TargetField;
import org.instancio.internal.selectors.TargetRoot;
import org.instancio.internal.selectors.TargetSetter;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Fail;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectorMapImpl<V>
implements SelectorMap<V> {
    private static final boolean FIND_ONE_ONLY = true;
    private static final ScopelessSelector SCOPELESS_ROOT = new ScopelessSelector(null);
    private final Map<ScopelessSelector, List<SelectorImpl>> scopelessSelectors = new LinkedHashMap<ScopelessSelector, List<SelectorImpl>>(0);
    private final Map<TargetSelector, V> selectors = new LinkedHashMap<TargetSelector, V>(0);
    private final Set<TargetSelector> unusedSelectors = new LinkedHashSet<TargetSelector>(0);
    private final Set<PredicateSelectorEntry<V>> predicateSelectors = new SortedSetWithReverseInsertionOrder<PredicateSelectorEntry>(Comparator.comparingInt(o -> ((PredicateSelectorEntry)o).predicateSelector.getPriority()));

    SelectorMapImpl() {
    }

    @Override
    public void forEach(BiConsumer<TargetSelector, V> action) {
        for (Map.Entry<TargetSelector, V> entry : this.selectors.entrySet()) {
            TargetSelector selector = entry.getKey();
            V value = entry.getValue();
            action.accept(selector, value);
        }
        for (PredicateSelectorEntry predicateSelectorEntry : this.predicateSelectors) {
            action.accept(predicateSelectorEntry.predicateSelector, predicateSelectorEntry.value);
        }
    }

    @Override
    public void put(TargetSelector targetSelector, V value) {
        if (targetSelector instanceof SelectorImpl) {
            ScopelessSelector scopeless;
            SelectorImpl selector = (SelectorImpl)targetSelector;
            Target target = selector.getTarget();
            if (target instanceof TargetClass) {
                scopeless = new ScopelessSelector(selector.getTargetClass());
            } else if (target instanceof TargetField) {
                TargetField t = (TargetField)target;
                Field field = t.getField();
                scopeless = new ScopelessSelector(field.getDeclaringClass(), field);
            } else if (target instanceof TargetSetter) {
                TargetSetter t = (TargetSetter)target;
                Method method = t.getSetter();
                scopeless = new ScopelessSelector(method.getDeclaringClass(), method);
            } else if (target instanceof TargetRoot) {
                scopeless = SCOPELESS_ROOT;
            } else {
                throw Fail.withFataInternalError("Unhandled selector target: %s", target.getTargetClass());
            }
            this.selectors.put(selector, value);
            this.scopelessSelectors.computeIfAbsent(scopeless, selectorList -> new ArrayList(3)).add(selector);
            if (!selector.isLenient()) {
                this.unusedSelectors.add(selector);
            }
        } else if (targetSelector instanceof PredicateSelector) {
            PredicateSelectorImpl selector = (PredicateSelectorImpl)targetSelector;
            this.predicateSelectors.add(new PredicateSelectorEntry(selector, value));
        } else {
            throw Fail.withFataInternalError("Invalid selector type: %s", targetSelector.getClass().getName());
        }
    }

    @Override
    public Set<TargetSelector> getUnusedKeys() {
        HashSet<TargetSelector> unused = new HashSet<TargetSelector>(this.unusedSelectors);
        for (PredicateSelectorEntry<V> entry : this.predicateSelectors) {
            if (((PredicateSelectorEntry)entry).matched || ((PredicateSelectorEntry)entry).predicateSelector.isLenient()) continue;
            unused.add(((PredicateSelectorEntry)entry).predicateSelector);
        }
        return unused;
    }

    @Override
    public Optional<V> getValue(InternalNode node) {
        List<SelectorImpl> withParent = SelectorMapImpl.getSelectorsWithParent(node, this.getCandidates(node), true);
        if (!withParent.isEmpty()) {
            SelectorImpl selector = withParent.get(0);
            this.markUsed(selector);
            return Optional.of(this.selectors.get(selector));
        }
        return this.getPredicateSelectorMatch(node);
    }

    private Optional<V> getPredicateSelectorMatch(InternalNode node) {
        for (PredicateSelectorEntry<V> entry : this.predicateSelectors) {
            if (!SelectorMapImpl.isPredicateMatch(node, entry)) continue;
            ((PredicateSelectorEntry)entry).matched = true;
            return Optional.of(((PredicateSelectorEntry)entry).value);
        }
        return Optional.empty();
    }

    @Override
    public List<V> getValues(InternalNode node) {
        List<SelectorImpl> selectorsWithParent = SelectorMapImpl.getSelectorsWithParent(node, this.getCandidates(node), false);
        ArrayList<Object> values = new ArrayList<Object>();
        for (SelectorImpl selectorImpl : selectorsWithParent) {
            this.markUsed(selectorImpl);
            values.add(this.selectors.get(selectorImpl));
        }
        for (PredicateSelectorEntry predicateSelectorEntry : this.predicateSelectors) {
            if (!SelectorMapImpl.isPredicateMatch(node, predicateSelectorEntry)) continue;
            predicateSelectorEntry.matched = true;
            values.add(predicateSelectorEntry.value);
        }
        return values;
    }

    @Override
    public List<V> getValues(TargetSelector selector) {
        ArrayList<Object> results = new ArrayList<Object>();
        V v = this.selectors.get(selector);
        if (v != null) {
            results.add(v);
        }
        for (PredicateSelectorEntry<V> entry : this.predicateSelectors) {
            if (!((PredicateSelectorEntry)entry).predicateSelector.equals(selector)) continue;
            results.add(((PredicateSelectorEntry)entry).value);
        }
        return results;
    }

    @Override
    public Set<TargetSelector> getSelectors(InternalNode node) {
        List<SelectorImpl> selectorsWithParent = SelectorMapImpl.getSelectorsWithParent(node, this.getCandidates(node), false);
        HashSet<TargetSelector> results = new HashSet<TargetSelector>(selectorsWithParent);
        for (PredicateSelectorEntry<V> entry : this.predicateSelectors) {
            if (!SelectorMapImpl.isPredicateMatch(node, entry)) continue;
            results.add(((PredicateSelectorEntry)entry).predicateSelector);
        }
        return results;
    }

    private static boolean isPredicateMatch(InternalNode targetNode, PredicateSelectorEntry<?> entry) {
        return ((PredicateSelectorEntry)entry).predicateSelector.getNodePredicate().test(targetNode) && SelectorMapImpl.selectorScopesMatchNodeHierarchy(null, ((PredicateSelectorEntry)entry).predicateSelector.getScopes(), targetNode);
    }

    private void markUsed(SelectorImpl selector) {
        if (selector.getParent() instanceof PrimitiveAndWrapperSelectorImpl) {
            SelectorImpl equivalent = selector.toBuilder().target(new TargetClass(PrimitiveWrapperBiLookup.getEquivalent(selector.getTargetClass()))).build();
            this.unusedSelectors.remove(equivalent);
        }
        this.unusedSelectors.remove(selector);
    }

    private List<SelectorImpl> getCandidates(InternalNode node) {
        ScopelessSelector key;
        if (node.getParent() == null && this.scopelessSelectors.containsKey(SCOPELESS_ROOT)) {
            return Collections.singletonList(this.scopelessSelectors.get(SCOPELESS_ROOT).get(0));
        }
        ArrayList<SelectorImpl> candidates = new ArrayList<SelectorImpl>();
        candidates.addAll(this.scopelessSelectors.getOrDefault(new ScopelessSelector(node.getRawType()), Collections.emptyList()));
        if (node.getSetter() != null) {
            key = new ScopelessSelector(node.getSetter().getDeclaringClass(), node.getSetter());
            candidates.addAll(this.scopelessSelectors.getOrDefault(key, Collections.emptyList()));
        }
        if (node.getField() != null) {
            key = new ScopelessSelector(node.getField().getDeclaringClass(), node.getField());
            candidates.addAll(this.scopelessSelectors.getOrDefault(key, Collections.emptyList()));
        }
        return candidates;
    }

    private static List<SelectorImpl> getSelectorsWithParent(InternalNode targetNode, List<SelectorImpl> candidates, boolean findOneOnly) {
        if (candidates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SelectorImpl> results = new ArrayList<SelectorImpl>(3);
        for (int i = candidates.size() - 1; i >= 0 && (!findOneOnly || results.isEmpty()); --i) {
            SelectorImpl candidate = candidates.get(i);
            if (!SelectorMapImpl.selectorScopesMatchNodeHierarchy(candidate.getDepth(), candidate.getScopes(), targetNode)) continue;
            results.add(candidate);
        }
        return results;
    }

    private static boolean selectorScopesMatchNodeHierarchy(@Nullable Integer candidateDepth, @NotNull List<Scope> candidateScopes, @NotNull InternalNode targetNode) {
        if (candidateDepth != null && candidateDepth.intValue() != targetNode.getDepth()) {
            return false;
        }
        if (candidateScopes.isEmpty()) {
            return true;
        }
        ArrayDeque<Scope> deq = new ArrayDeque<Scope>(candidateScopes);
        Scope scope = (Scope)deq.removeLast();
        InternalNode node = targetNode;
        while (node != null) {
            boolean scopeMatched;
            boolean bl = scopeMatched = scope instanceof ScopeImpl ? SelectorMapImpl.isRegularScopeMatch((ScopeImpl)scope, node) : SelectorMapImpl.isPredicateScopeMatch((PredicateScopeImpl)scope, node);
            if (scopeMatched) {
                scope = (Scope)deq.pollLast();
                if (scope != null) continue;
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private static boolean isPredicateScopeMatch(PredicateScopeImpl scope, InternalNode node) {
        return scope.getNodePredicate().test(node);
    }

    private static boolean isRegularScopeMatch(ScopeImpl scope, InternalNode node) {
        boolean matched = false;
        if (scope.getDepth() == null || node.getDepth() >= scope.getDepth()) {
            matched = scope.getTarget() instanceof TargetField ? node.getField() != null && scope.getTargetClass().equals(node.getField().getDeclaringClass()) && scope.getField().equals(node.getField()) : (scope.getTarget() instanceof TargetSetter ? node.getSetter() != null && scope.getTargetClass().equals(node.getSetter().getDeclaringClass()) && scope.getMethodName().equals(node.getSetter().getName()) && (scope.getParameterType() == null || scope.getParameterType().equals(node.getSetter().getParameterTypes()[0])) : node.getRawType().equals(scope.getTargetClass()) || node.getTargetClass().equals(scope.getTargetClass()));
        }
        return matched;
    }

    public String toString() {
        if (this.selectors.isEmpty() && this.predicateSelectors.isEmpty()) {
            return "SelectorMap{}";
        }
        StringBuilder sb = new StringBuilder(1024).append("SelectorMap{").append(Constants.NL);
        for (Map.Entry<TargetSelector, V> entry : this.selectors.entrySet()) {
            sb.append("  [REGULAR] ").append(entry).append(Constants.NL);
        }
        for (PredicateSelectorEntry predicateSelectorEntry : this.predicateSelectors) {
            sb.append("  [PREDICATE] ").append(predicateSelectorEntry.predicateSelector).append('=').append(predicateSelectorEntry.value).append(Constants.NL);
        }
        sb.append('}');
        return sb.toString();
    }

    private static final class PredicateSelectorEntry<V> {
        private final PredicateSelectorImpl predicateSelector;
        private final V value;
        private boolean matched;

        private PredicateSelectorEntry(PredicateSelectorImpl predicateSelector, V value) {
            this.predicateSelector = predicateSelector;
            this.value = value;
        }
    }
}

