/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.LinkedHashMap;
import java.util.Map;
import org.instancio.TargetSelector;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.nodes.InternalNode;

public class ModelContextSelectorMap {
    private final SelectorMap<ModelContext<?>> selectorMap = new SelectorMapImpl();
    private final Map<TargetSelector, ModelContext<?>> modelContexts = new LinkedHashMap();

    void putAll(Map<TargetSelector, ModelContext<?>> modelContexts) {
        for (Map.Entry<TargetSelector, ModelContext<?>> entry : modelContexts.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    void put(TargetSelector selector, ModelContext<?> value) {
        this.modelContexts.put(selector, value);
        this.selectorMap.put(selector, value);
    }

    public SelectorMap<ModelContext<?>> getSelectorMap() {
        return this.selectorMap;
    }

    public Map<TargetSelector, ModelContext<?>> getModelContextSelectors() {
        return this.modelContexts;
    }

    public ModelContext<?> getContext(InternalNode node) {
        return this.selectorMap.getValue(node).orElse(null);
    }
}

