/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.util.TypeUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ModelContextHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ModelContextHelper.class);

    static Map<TypeVariable<?>, Type> buildRootTypeMap(Type rootType, List<Type> rootTypeParameters) {
        Class rootClass = TypeUtils.getRawType(rootType);
        ApiValidator.validateTypeParameters(rootClass, rootTypeParameters);
        Class<Object> targetClass = rootClass.isArray() ? rootClass.getComponentType() : rootClass;
        TypeVariable<Class<Object>>[] typeVariables = targetClass.getTypeParameters();
        HashMap typeMap = new HashMap();
        for (int i = 0; i < typeVariables.length; ++i) {
            TypeVariable<Class<Object>> typeVariable = typeVariables[i];
            Type actualType = rootTypeParameters.get(i);
            LOG.trace("Mapping type variable '{}' to '{}'", typeVariable, (Object)actualType);
            typeMap.put(typeVariable, actualType);
        }
        ModelContextHelper.populateTypeMapFromGenericSuperclass(rootClass, typeMap);
        return typeMap;
    }

    private static void populateTypeMapFromGenericSuperclass(@Nullable Class<?> rootClass, Map<TypeVariable<?>, Type> typeMap) {
        if (rootClass == null) {
            return;
        }
        Type gsClass = rootClass.getGenericSuperclass();
        if (gsClass instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)gsClass;
            Class rawType = TypeUtils.getRawType(genericSuperclass.getRawType());
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            Type[] actualTypeArguments = genericSuperclass.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (actualTypeArguments[i] instanceof TypeVariable) continue;
                TypeVariable typeVariable = typeParameters[i];
                Class actualType = TypeUtils.getRawType(actualTypeArguments[i]);
                LOG.trace("Mapping type variable '{}' to '{}'", typeVariable, actualType);
                typeMap.put(typeVariable, actualType);
            }
        }
        if (gsClass != null) {
            ModelContextHelper.populateTypeMapFromGenericSuperclass(TypeUtils.getRawType(gsClass), typeMap);
        }
    }

    private ModelContextHelper() {
    }
}

