/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.instancio.Assignment;
import org.instancio.GeneratorSpecProvider;
import org.instancio.Model;
import org.instancio.OnCompleteCallback;
import org.instancio.Random;
import org.instancio.TargetSelector;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.Flattener;
import org.instancio.internal.InternalModel;
import org.instancio.internal.RandomHelper;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.ApiMethodSelector;
import org.instancio.internal.context.AssignmentSelectorMap;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.GeneratorSelectorMap;
import org.instancio.internal.context.ModelContextHelper;
import org.instancio.internal.context.ModelContextSelectorMap;
import org.instancio.internal.context.OnCompleteCallbackSelectorMap;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorNodeMatchesCollector;
import org.instancio.internal.context.SetModelSelectorHelper;
import org.instancio.internal.context.SubtypeSelectorMap;
import org.instancio.internal.context.UnusedEmitItemsReporter;
import org.instancio.internal.context.UnusedSelectorReporter;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.selectors.SelectorProcessor;
import org.instancio.internal.selectors.SetterSelectorHolder;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.internal.spi.InternalServiceProviderContext;
import org.instancio.internal.spi.InternalServiceProviderImpl;
import org.instancio.internal.spi.Providers;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ServiceLoaders;
import org.instancio.internal.util.SystemProperties;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.Mode;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;
import org.instancio.spi.InstancioServiceProvider;
import org.instancio.support.Global;
import org.instancio.support.ThreadLocalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelContext<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ModelContext.class);
    private static final List<InternalServiceProvider> INTERNAL_SERVICE_PROVIDERS = CollectionUtils.combine(ServiceLoaders.loadAll(InternalServiceProvider.class), new InternalServiceProviderImpl());
    private final Providers providers;
    private final Type rootType;
    private final List<Type> rootTypeParameters;
    private final Map<TypeVariable<?>, Type> rootTypeMap;
    private final Integer maxDepth;
    private final Long seed;
    private final Random random;
    private final Settings settings;
    private final ModelContextSelectorMap modelContextSelectorMap = new ModelContextSelectorMap();
    private final BooleanSelectorMap ignoredSelectorMap = new BooleanSelectorMap();
    private final BooleanSelectorMap nullableSelectorMap = new BooleanSelectorMap();
    private final OnCompleteCallbackSelectorMap onCompleteCallbackSelectorMap = new OnCompleteCallbackSelectorMap();
    private final SubtypeSelectorMap subtypeSelectorMap = new SubtypeSelectorMap();
    private final GeneratorSelectorMap generatorSelectorMap;
    private final AssignmentSelectorMap assignmentSelectorMap;
    private final boolean verbose;

    private ModelContext(Builder<T> builder) {
        this.rootType = ((Builder)builder).rootType;
        this.rootTypeParameters = Collections.unmodifiableList(((Builder)builder).rootTypeParameters);
        this.rootTypeMap = this.rootType instanceof ParameterizedType || this.rootType instanceof GenericArrayType ? Collections.emptyMap() : Collections.unmodifiableMap(ModelContextHelper.buildRootTypeMap(((Builder)builder).rootType, ((Builder)builder).rootTypeParameters));
        this.seed = ((Builder)builder).seed;
        this.maxDepth = ((Builder)builder).maxDepth;
        this.verbose = ((Builder)builder).verbose;
        this.settings = ModelContext.createSettings(builder);
        this.random = RandomHelper.resolveRandom(this.settings.get(Keys.SEED), ((Builder)builder).seed);
        GeneratorContext generatorContext = new GeneratorContext(this.settings, this.random);
        this.generatorSelectorMap = new GeneratorSelectorMap(generatorContext);
        this.assignmentSelectorMap = new AssignmentSelectorMap(generatorContext);
        this.initSelectorMaps(builder);
        this.providers = new Providers(ServiceLoaders.loadAll(InstancioServiceProvider.class), new InternalServiceProviderContext(this.settings, this.random));
    }

    private void initSelectorMaps(Builder<T> builder) {
        ((Builder)builder).modelContexts.forEach(this::copyToThisContext);
        this.modelContextSelectorMap.putAll(((Builder)builder).modelContexts);
        this.ignoredSelectorMap.putAll(((Builder)builder).ignoredTargets);
        this.nullableSelectorMap.putAll(((Builder)builder).nullableTargets);
        this.onCompleteCallbackSelectorMap.putAll(((Builder)builder).onCompleteCallbacks);
        this.generatorSelectorMap.putAllGeneratorSpecs(((Builder)builder).generatorSpecSelectors);
        this.generatorSelectorMap.putAllGenerators(((Builder)builder).generatorSelectors);
        this.assignmentSelectorMap.putAll(((Builder)builder).assignmentSelectors);
        this.subtypeSelectorMap.putAll(((Builder)builder).subtypeSelectors);
        this.generatorSelectorMap.getGeneratorSubtypeMap().forEach((k, v) -> this.subtypeSelectorMap.getSelectorMap().put((TargetSelector)k, (Class<?>)v));
        this.assignmentSelectorMap.getGeneratorSubtypeMap().forEach((k, v) -> this.subtypeSelectorMap.getSelectorMap().put((TargetSelector)k, (Class<?>)v));
    }

    private static Settings createSettings(Builder<?> builder) {
        AssignmentType assignmentTypeOverride;
        Settings settings = Global.getPropertiesFileSettings().merge(ThreadLocalSettings.getInstance().get()).merge(((Builder)builder).settings);
        if (Boolean.TRUE.equals(((Builder)builder).lenient)) {
            settings.set(Keys.MODE, Mode.LENIENT);
        }
        if ((assignmentTypeOverride = SystemProperties.getAssignmentType()) != null) {
            settings.set(Keys.ASSIGNMENT_TYPE, assignmentTypeOverride);
        }
        LOG.trace("Resolved settings: {}", (Object)settings);
        SetterSelectorHolder holder = ((Builder)builder).getSetMethodSelectorHolder();
        ApiValidator.failIfMethodSelectorIsUsedWithFieldAssignment(settings.get(Keys.ASSIGNMENT_TYPE), holder.getSetterSelector());
        return settings.lock();
    }

    public List<InternalServiceProvider> getInternalServiceProviders() {
        return INTERNAL_SERVICE_PROVIDERS;
    }

    public Providers getServiceProviders() {
        return this.providers;
    }

    public void reportWarnings() {
        this.reportUnusedSelectorWarnings();
        this.reportEmitGeneratorWarnings();
    }

    private void reportEmitGeneratorWarnings() {
        SelectorMap<Generator<?>> selectorMap = this.generatorSelectorMap.getSelectorMap();
        UnusedEmitItemsReporter reporter = new UnusedEmitItemsReporter(selectorMap);
        reporter.report();
    }

    void reportUnusedSelectorWarnings() {
        if (this.settings.get(Keys.MODE) == Mode.STRICT) {
            UnusedSelectorReporter reporter = UnusedSelectorReporter.builder().maxDepth(this.getMaxDepth()).ignored(this.ignoredSelectorMap.getSelectorMap().getUnusedKeys()).nullable(this.nullableSelectorMap.getSelectorMap().getUnusedKeys()).generators(this.generatorSelectorMap.getSelectorMap().getUnusedKeys()).callbacks(this.onCompleteCallbackSelectorMap.getSelectorMap().getUnusedKeys()).subtypes(this.subtypeSelectorMap.getSelectorMap().getUnusedKeys()).assignmentOrigins(this.assignmentSelectorMap.getDestinationSelectors().getSelectorMap().getUnusedKeys()).assignmentDestinations(this.assignmentSelectorMap.getSelectorMap().getUnusedKeys()).modelContexts(this.modelContextSelectorMap.getSelectorMap().getUnusedKeys()).build();
            reporter.report();
        }
    }

    public Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> getSelectors(InternalNode rootNode) {
        SelectorNodeMatchesCollector collector = SelectorNodeMatchesCollector.builder().ignoredSelectorMap(this.ignoredSelectorMap.getSelectorMap()).nullableSelectorMap(this.nullableSelectorMap.getSelectorMap()).onCompleteCallbackSelectorMap(this.onCompleteCallbackSelectorMap.getSelectorMap()).subtypeSelectorMap(this.subtypeSelectorMap.getSelectorMap()).generatorSelectorMap(this.generatorSelectorMap.getSelectorMap()).assignmentOriginSelectorMap(this.assignmentSelectorMap.getOriginSelectors().getSelectorMap()).assignmentDestinationSelectorMap(this.assignmentSelectorMap.getDestinationSelectors().getSelectorMap()).build();
        return collector.getNodeMatches(rootNode);
    }

    public Type getRootType() {
        return this.rootType;
    }

    public Integer getMaxDepth() {
        return ObjectUtils.defaultIfNull(this.maxDepth, this.settings.get(Keys.MAX_DEPTH));
    }

    public boolean isIgnored(InternalNode node) {
        return this.ignoredSelectorMap.isTrue(node);
    }

    public boolean isNullable(InternalNode node) {
        return this.nullableSelectorMap.isTrue(node);
    }

    public Optional<Generator<?>> getGenerator(InternalNode node) {
        return this.generatorSelectorMap.getGenerator(node);
    }

    public List<OnCompleteCallback<?>> getCallbacks(InternalNode node) {
        return this.onCompleteCallbackSelectorMap.getCallbacks(node);
    }

    public BooleanSelectorMap getIgnoredSelectorMap() {
        return this.ignoredSelectorMap;
    }

    public SubtypeSelectorMap getSubtypeSelectorMap() {
        return this.subtypeSelectorMap;
    }

    public ModelContextSelectorMap getModelContextSelectorMap() {
        return this.modelContextSelectorMap;
    }

    public Map<TypeVariable<?>, Type> getRootTypeMap() {
        return this.rootTypeMap;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Random getRandom() {
        return this.random;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Builder<T> toBuilder() {
        Builder builder = new Builder(this.rootType);
        builder.rootTypeParameters.addAll(this.rootTypeParameters);
        builder.maxDepth = this.maxDepth;
        builder.seed = this.seed;
        builder.settings = this.settings;
        builder.nullableTargets.addAll(this.nullableSelectorMap.getTargetSelectors());
        builder.ignoredTargets.addAll(this.ignoredSelectorMap.getTargetSelectors());
        builder.generatorSelectors.putAll(this.generatorSelectorMap.getGeneratorSelectors());
        builder.generatorSpecSelectors.putAll(this.generatorSelectorMap.getGeneratorSpecSelectors());
        builder.subtypeSelectors.putAll(this.subtypeSelectorMap.getSubtypeSelectors());
        builder.onCompleteCallbacks.putAll(this.onCompleteCallbackSelectorMap.getOnCompleteCallbackSelectors());
        builder.assignmentSelectors.putAll(this.assignmentSelectorMap.getAssignmentSelectors());
        builder.modelContexts.putAll(this.modelContextSelectorMap.getModelContextSelectors());
        return builder;
    }

    public static <T> Builder<T> builder(Type rootType) {
        return new Builder(rootType);
    }

    public List<InternalAssignment> getAssignments(InternalNode node) {
        return this.assignmentSelectorMap.getAssignments(node);
    }

    public BooleanSelectorMap getAssignmentOriginSelectorMap() {
        return this.assignmentSelectorMap.getOriginSelectors();
    }

    public List<TargetSelector> getAssignmentDestinationSelectors(InternalNode node) {
        return this.assignmentSelectorMap.getDestinationSelectors(node);
    }

    private void copyToThisContext(TargetSelector modelTarget, ModelContext<?> otherCtx) {
        otherCtx.generatorSelectorMap.getGeneratorSelectors().forEach((selector, generator) -> {
            TargetSelector resolvedSelector = SetModelSelectorHelper.applyModelSelectorScopes(modelTarget, selector);
            this.generatorSelectorMap.putGenerator(resolvedSelector, (Generator<?>)generator);
        });
        otherCtx.generatorSelectorMap.getGeneratorSpecSelectors().forEach((selector, generator) -> {
            TargetSelector resolvedSelector = SetModelSelectorHelper.applyModelSelectorScopes(modelTarget, selector);
            this.generatorSelectorMap.putGeneratorSpec(resolvedSelector, (GeneratorSpecProvider<?>)generator);
        });
        otherCtx.ignoredSelectorMap.getTargetSelectors().forEach(selector -> {
            TargetSelector resolvedSelector = SetModelSelectorHelper.applyModelSelectorScopes(modelTarget, selector);
            this.ignoredSelectorMap.add(resolvedSelector);
        });
        otherCtx.nullableSelectorMap.getTargetSelectors().forEach(selector -> {
            TargetSelector resolvedSelector = SetModelSelectorHelper.applyModelSelectorScopes(modelTarget, selector);
            this.nullableSelectorMap.add(resolvedSelector);
        });
        otherCtx.onCompleteCallbackSelectorMap.getOnCompleteCallbackSelectors().forEach((selector, callback) -> {
            TargetSelector resolvedSelector = SetModelSelectorHelper.applyModelSelectorScopes(modelTarget, selector);
            this.onCompleteCallbackSelectorMap.put(resolvedSelector, (OnCompleteCallback<?>)callback);
        });
        otherCtx.assignmentSelectorMap.getAssignmentSelectors().forEach((selector, assignments) -> {
            ArrayList<Assignment> updatedAssignments = new ArrayList<Assignment>(assignments.size());
            for (Assignment assignment : assignments) {
                InternalAssignment a = (InternalAssignment)assignment;
                TargetSelector updatedOrigin = SetModelSelectorHelper.applyModelSelectorScopes(modelTarget, a.getOrigin());
                TargetSelector updatedDestination = SetModelSelectorHelper.applyModelSelectorScopes(modelTarget, a.getDestination());
                InternalAssignment updatedAssignment = a.toBuilder().origin(updatedOrigin).destination(updatedDestination).build();
                updatedAssignments.add(updatedAssignment);
            }
            TargetSelector resolvedSelector = SetModelSelectorHelper.applyModelSelectorScopes(modelTarget, selector);
            this.assignmentSelectorMap.put(resolvedSelector, updatedAssignments);
        });
        otherCtx.subtypeSelectorMap.getSubtypeSelectors().forEach((selector, subtype) -> {
            TargetSelector resolvedSelector = SetModelSelectorHelper.applyModelSelectorScopes(modelTarget, selector);
            this.subtypeSelectorMap.put(resolvedSelector, (Class<?>)subtype);
        });
    }

    public static final class Builder<T> {
        private final Type rootType;
        private final Class<T> rootClass;
        private final List<Type> rootTypeParameters = new ArrayList<Type>();
        private final Map<TargetSelector, Class<?>> subtypeSelectors = new LinkedHashMap();
        private final Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecSelectors = new LinkedHashMap();
        private final Map<TargetSelector, Generator<?>> generatorSelectors = new LinkedHashMap();
        private final Map<TargetSelector, OnCompleteCallback<?>> onCompleteCallbacks = new LinkedHashMap();
        private final Map<TargetSelector, List<Assignment>> assignmentSelectors = new LinkedHashMap<TargetSelector, List<Assignment>>();
        private final Map<TargetSelector, ModelContext<?>> modelContexts = new LinkedHashMap();
        private final Set<TargetSelector> ignoredTargets = new LinkedHashSet<TargetSelector>();
        private final Set<TargetSelector> nullableTargets = new LinkedHashSet<TargetSelector>();
        private final SetterSelectorHolder setMethodSelectorHolder = new SetterSelectorHolder();
        private final SelectorProcessor selectorProcessor;
        private Settings settings;
        private Integer maxDepth;
        private Long seed;
        private Boolean lenient;
        private boolean verbose;

        private Builder(Type rootType) {
            ApiValidator.validateRootClass(rootType);
            this.rootType = rootType;
            this.rootClass = TypeUtils.getRawType(this.rootType);
            this.selectorProcessor = new SelectorProcessor(this.rootClass, INTERNAL_SERVICE_PROVIDERS, this.setMethodSelectorHolder);
        }

        private SetterSelectorHolder getSetMethodSelectorHolder() {
            return this.setMethodSelectorHolder;
        }

        public Builder<T> withRootTypeParameters(List<Type> rootTypeParameters) {
            ApiValidator.validateTypeParameters(this.rootClass, rootTypeParameters);
            this.rootTypeParameters.addAll(rootTypeParameters);
            return this;
        }

        private <V> Builder<T> putSelector(Map<TargetSelector, V> map, TargetSelector selector, V value) {
            List<TargetSelector> processed = this.selectorProcessor.process(selector);
            processed.forEach(s -> map.put((TargetSelector)s, value));
            return this;
        }

        public Builder<T> withSubtype(TargetSelector selector, Class<?> subtype) {
            ApiValidator.notNull(subtype, "subtype must not be null", new Object[0]);
            return this.putSelector(this.subtypeSelectors, selector, subtype);
        }

        public Builder<T> withGenerator(TargetSelector selector, Generator<?> generator) {
            ApiValidator.validateGeneratorNotNull(generator);
            return this.putSelector(this.generatorSelectors, selector, generator);
        }

        public Builder<T> withSupplier(TargetSelector selector, Supplier<?> supplier) {
            ApiValidator.validateSupplierNotNull(supplier);
            return this.withGenerator(selector, GeneratorDecorator.decorate(supplier));
        }

        public <V> Builder<T> withGeneratorSpec(TargetSelector selector, GeneratorSpecProvider<V> spec) {
            ApiValidator.validateGenerateSecondArgument(spec);
            return this.putSelector(this.generatorSpecSelectors, selector, spec);
        }

        public Builder<T> withOnCompleteCallback(TargetSelector selector, OnCompleteCallback<?> callback) {
            return this.putSelector(this.onCompleteCallbacks, selector, callback);
        }

        public Builder<T> withIgnored(TargetSelector selector) {
            this.ignoredTargets.addAll(this.selectorProcessor.process(selector));
            return this;
        }

        public Builder<T> withNullable(TargetSelector selector) {
            this.nullableTargets.addAll(this.selectorProcessor.process(selector));
            return this;
        }

        public Builder<T> withMaxDepth(int maxDepth) {
            ApiValidator.isTrue(maxDepth >= 0, "Maximum depth must not be negative: %s", maxDepth);
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder<T> withAssignments(Assignment ... assignments) {
            ApiValidator.notNull(assignments, "assignments array must not be null", new Object[0]);
            for (Assignment assignment : assignments) {
                ApiValidator.notNull(assignment, "assignments array must not contain null", new Object[0]);
                this.processAssignment(assignment);
            }
            return this;
        }

        private void processAssignment(Assignment assignment) {
            List assignments = ((Flattener)((Object)assignment)).flatten();
            for (InternalAssignment a : assignments) {
                List<TargetSelector> origin = this.selectorProcessor.process(a.getOrigin());
                List<TargetSelector> destinations = this.selectorProcessor.process(a.getDestination());
                Verify.isTrue(origin.size() == 1, "Origin has multiple selectors", new Object[0]);
                for (TargetSelector destination : destinations) {
                    InternalAssignment processedAssignment = a.toBuilder().origin(origin.get(0)).destination(destination).build();
                    this.assignmentSelectors.computeIfAbsent(destination, k -> new ArrayList()).add(processedAssignment);
                }
            }
        }

        public <V> Builder<T> withSetting(SettingKey<V> key, V value) {
            if (this.settings == null) {
                this.settings = Settings.create();
            } else if (this.settings.isLocked()) {
                this.settings = Settings.from(this.settings);
            }
            this.settings.set(key, value);
            return this;
        }

        public Builder<T> withSettings(Settings arg) {
            ApiValidator.notNull(arg, "Null Settings provided to withSettings() method", new Object[0]);
            this.settings = this.settings == null ? Settings.from(arg) : this.settings.merge(arg);
            return this;
        }

        public Builder<T> withSeed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder<T> lenient() {
            this.lenient = true;
            return this;
        }

        public Builder<T> verbose() {
            this.verbose = true;
            return this;
        }

        public Builder<T> useModelAsTypeArgument(ModelContext<?> otherContext) {
            this.rootTypeParameters.add(otherContext.getRootType());
            this.seed = ((ModelContext)otherContext).seed;
            this.nullableTargets.addAll(((ModelContext)otherContext).nullableSelectorMap.getTargetSelectors());
            this.ignoredTargets.addAll(((ModelContext)otherContext).ignoredSelectorMap.getTargetSelectors());
            this.generatorSelectors.putAll(((ModelContext)otherContext).generatorSelectorMap.getGeneratorSelectors());
            this.generatorSpecSelectors.putAll(((ModelContext)otherContext).generatorSelectorMap.getGeneratorSpecSelectors());
            this.subtypeSelectors.putAll(((ModelContext)otherContext).subtypeSelectorMap.getSubtypeSelectors());
            this.onCompleteCallbacks.putAll(((ModelContext)otherContext).onCompleteCallbackSelectorMap.getOnCompleteCallbackSelectors());
            this.assignmentSelectors.putAll(((ModelContext)otherContext).assignmentSelectorMap.getAssignmentSelectors());
            this.modelContexts.putAll(((ModelContext)otherContext).modelContextSelectorMap.getModelContextSelectors());
            this.maxDepth = ((ModelContext)otherContext).maxDepth == null ? null : Integer.valueOf(((ModelContext)otherContext).maxDepth + 1);
            this.settings = Settings.from(((ModelContext)otherContext).settings).set(Keys.MAX_DEPTH, ((ModelContext)otherContext).settings.get(Keys.MAX_DEPTH) + 1).lock();
            return this;
        }

        public void withModel(TargetSelector modelSelector, Model<?> model) {
            ModelContext otherCtx = ((InternalModel)model).getModelContext();
            List<TargetSelector> processedSelectors = this.selectorProcessor.process(modelSelector);
            for (TargetSelector modelTarget : processedSelectors) {
                this.modelContexts.put(modelTarget, otherCtx);
            }
        }

        public ModelContext<T> build() {
            return new ModelContext(this);
        }
    }
}

