/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.instancio.GeneratorSpecProvider;
import org.instancio.TargetSelector;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generators.Generators;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;

class GeneratorSelectorMap {
    private final GeneratorContext context;
    private final AfterGenerate defaultAfterGenerate;
    private final SelectorMap<Generator<?>> selectorMap = new SelectorMapImpl();
    private final Map<TargetSelector, Generator<?>> generatorSelectors = new LinkedHashMap();
    private final Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecSelectors = new LinkedHashMap();
    private final Map<TargetSelector, Class<?>> generatorSubtypeMap = new LinkedHashMap();
    private final Generators generators;

    GeneratorSelectorMap(@NotNull GeneratorContext context) {
        this.context = context;
        this.generators = new Generators(context);
        this.defaultAfterGenerate = context.getSettings().get(Keys.AFTER_GENERATE_HINT);
    }

    void putGenerator(TargetSelector targetSelector, Generator<?> generator) {
        this.generatorSelectors.put(targetSelector, generator);
        this.addToSelectorMap(targetSelector, generator);
    }

    void putGeneratorSpec(TargetSelector targetSelector, GeneratorSpecProvider<?> genFn) {
        this.generatorSpecSelectors.put(targetSelector, genFn);
        this.addToSelectorMap(targetSelector, (Generator)genFn.getSpec(this.generators));
    }

    void putAllGenerators(Map<TargetSelector, Generator<?>> generatorMap) {
        for (Map.Entry<TargetSelector, Generator<?>> entry : generatorMap.entrySet()) {
            this.putGenerator(entry.getKey(), entry.getValue());
        }
    }

    void putAllGeneratorSpecs(Map<TargetSelector, GeneratorSpecProvider<?>> specs) {
        for (Map.Entry<TargetSelector, GeneratorSpecProvider<?>> entry : specs.entrySet()) {
            this.putGeneratorSpec(entry.getKey(), entry.getValue());
        }
    }

    private void addToSelectorMap(TargetSelector targetSelector, Generator<?> g) {
        g.init(this.context);
        Generator<?> generator = GeneratorDecorator.decorateIfNullAfterGenerate(g, this.defaultAfterGenerate);
        this.selectorMap.put(targetSelector, generator);
        InternalGeneratorHint hint = generator.hints().get(InternalGeneratorHint.class);
        if (hint != null && hint.targetClass() != null) {
            this.generatorSubtypeMap.put(targetSelector, hint.targetClass());
        }
    }

    SelectorMap<Generator<?>> getSelectorMap() {
        return this.selectorMap;
    }

    Map<TargetSelector, Generator<?>> getGeneratorSelectors() {
        return this.generatorSelectors;
    }

    Map<TargetSelector, GeneratorSpecProvider<?>> getGeneratorSpecSelectors() {
        return this.generatorSpecSelectors;
    }

    Map<TargetSelector, Class<?>> getGeneratorSubtypeMap() {
        return Collections.unmodifiableMap(this.generatorSubtypeMap);
    }

    Optional<Generator<?>> getGenerator(InternalNode node) {
        return this.selectorMap.getValue(node);
    }
}

