/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.LinkedHashSet;
import java.util.Set;
import org.instancio.TargetSelector;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.nodes.InternalNode;

public class BooleanSelectorMap {
    private final SelectorMap<Boolean> selectorMap = new SelectorMapImpl<Boolean>();
    private final Set<TargetSelector> targetSelectors = new LinkedHashSet<TargetSelector>();

    public void putAll(Set<TargetSelector> targetSelectors) {
        for (TargetSelector targetSelector : targetSelectors) {
            this.add(targetSelector);
        }
    }

    void add(TargetSelector targetSelector) {
        this.targetSelectors.add(targetSelector);
        this.selectorMap.put(targetSelector, true);
    }

    public SelectorMap<Boolean> getSelectorMap() {
        return this.selectorMap;
    }

    public Set<TargetSelector> getTargetSelectors() {
        return this.targetSelectors;
    }

    public boolean isTrue(InternalNode node) {
        return Boolean.TRUE.equals(this.selectorMap.getValue(node).orElse(false));
    }
}

