/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.instancio.Assignment;
import org.instancio.TargetSelector;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generators.Generators;
import org.instancio.internal.assignment.GeneratorHolder;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.context.TargetSelectorSelectorMap;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.settings.Keys;
import org.jetbrains.annotations.NotNull;

final class AssignmentSelectorMap {
    private final GeneratorContext context;
    private final AfterGenerate defaultAfterGenerate;
    private final SelectorMap<List<InternalAssignment>> selectorMap = new SelectorMapImpl<List<InternalAssignment>>();
    private final Map<TargetSelector, List<Assignment>> assignmentSelectors = new LinkedHashMap<TargetSelector, List<Assignment>>();
    private final BooleanSelectorMap originSelectors = new BooleanSelectorMap();
    private final TargetSelectorSelectorMap destinationSelectors = new TargetSelectorSelectorMap();
    private final Map<TargetSelector, Class<?>> generatorSubtypeMap = new LinkedHashMap();

    AssignmentSelectorMap(@NotNull GeneratorContext context) {
        this.context = context;
        this.defaultAfterGenerate = context.getSettings().get(Keys.AFTER_GENERATE_HINT);
    }

    void putAll(@NotNull Map<TargetSelector, List<Assignment>> targetSelectors) {
        for (Map.Entry<TargetSelector, List<Assignment>> entry : targetSelectors.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    void put(TargetSelector targetSelector, List<Assignment> assignments) {
        this.assignmentSelectors.put(targetSelector, assignments);
        HashMap<TargetSelector, List> originDestinationsMap = new HashMap<TargetSelector, List>();
        List<InternalAssignment> processedAssignments = this.processAssignments(assignments);
        for (InternalAssignment internalAssignment : processedAssignments) {
            List destinations = originDestinationsMap.computeIfAbsent(internalAssignment.getOrigin(), k -> new ArrayList());
            destinations.add(internalAssignment.getDestination());
        }
        this.selectorMap.put(targetSelector, processedAssignments);
        this.originSelectors.putAll(originDestinationsMap.keySet());
        for (Map.Entry entry : originDestinationsMap.entrySet()) {
            TargetSelector selector = (TargetSelector)entry.getKey();
            List destinations = (List)entry.getValue();
            List<List<TargetSelector>> currentDestinations = this.destinationSelectors.getSelectorMap().getValues(selector);
            if (currentDestinations.isEmpty()) {
                this.destinationSelectors.getSelectorMap().put(selector, destinations);
                continue;
            }
            currentDestinations.forEach(currentList -> currentList.addAll(destinations));
        }
    }

    private List<InternalAssignment> processAssignments(List<Assignment> assignments) {
        ArrayList<InternalAssignment> processed = new ArrayList<InternalAssignment>(assignments.size());
        Generators generators = new Generators(this.context);
        for (Assignment c : assignments) {
            InternalAssignment assignment = (InternalAssignment)c;
            if (assignment.getGeneratorHolder() != null) {
                Generator generator = this.getGenerator(assignment, generators);
                InternalAssignment updated = assignment.toBuilder().generator(generator).build();
                processed.add(updated);
                continue;
            }
            processed.add(assignment);
        }
        return processed;
    }

    private <T> Generator<T> getGenerator(InternalAssignment assignment, Generators generators) {
        GeneratorHolder holder = assignment.getGeneratorHolder();
        Generator g = holder.getGenerator() == null ? (Generator)holder.getSpecProvider().getSpec(generators) : holder.getGenerator();
        g.init(this.context);
        Generator generator = GeneratorDecorator.decorateIfNullAfterGenerate(g, this.defaultAfterGenerate);
        InternalGeneratorHint hint = generator.hints().get(InternalGeneratorHint.class);
        if (hint != null && hint.targetClass() != null) {
            this.generatorSubtypeMap.put(assignment.getDestination(), hint.targetClass());
        }
        return generator;
    }

    public List<InternalAssignment> getAssignments(InternalNode node) {
        Optional<List<InternalAssignment>> value = this.selectorMap.getValue(node);
        return value.orElse(Collections.emptyList());
    }

    BooleanSelectorMap getOriginSelectors() {
        return this.originSelectors;
    }

    SelectorMap<List<InternalAssignment>> getSelectorMap() {
        return this.selectorMap;
    }

    TargetSelectorSelectorMap getDestinationSelectors() {
        return this.destinationSelectors;
    }

    Map<TargetSelector, List<Assignment>> getAssignmentSelectors() {
        return this.assignmentSelectors;
    }

    List<TargetSelector> getDestinationSelectors(InternalNode node) {
        return this.destinationSelectors.getTargetSelector(node);
    }

    Map<TargetSelector, Class<?>> getGeneratorSubtypeMap() {
        return this.generatorSubtypeMap;
    }
}

