/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Type;
import org.instancio.internal.GenerationListener;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.TypeUtils;

class SetModelValidatingListener
implements GenerationListener {
    private final ModelContext<?> context;

    SetModelValidatingListener(ModelContext<?> context) {
        this.context = context;
    }

    @Override
    public void objectCreated(InternalNode node, GeneratorResult result) {
        ModelContext<?> otherContext = this.context.getModelContextSelectorMap().getContext(node);
        if (otherContext == null) {
            return;
        }
        Type modelRootType = otherContext.getRootType();
        Class modelRawType = TypeUtils.getRawType(modelRootType);
        if (!modelRawType.isAssignableFrom(node.getTargetClass())) {
            String modelTypeName = Format.withoutPackage(modelRootType);
            throw Fail.withUsageError("Model<%s> specified in setModel() method is incompatible with the selector target%n%n -> Model type ............: %s%n -> Selector target type ..: %s", modelTypeName, modelTypeName, Format.withoutPackage(node.getType()));
        }
    }
}

