/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import org.instancio.Random;

public final class ArrayUtils {
    public static void shuffle(Object arr, Random random) {
        if (arr instanceof Object[]) {
            ArrayUtils.shuffleArray((Object[])arr, random);
        } else if (arr instanceof byte[]) {
            ArrayUtils.shuffleArray((byte[])arr, random);
        } else if (arr instanceof short[]) {
            ArrayUtils.shuffleArray((short[])arr, random);
        } else if (arr instanceof int[]) {
            ArrayUtils.shuffleArray((int[])arr, random);
        } else if (arr instanceof long[]) {
            ArrayUtils.shuffleArray((long[])arr, random);
        } else if (arr instanceof float[]) {
            ArrayUtils.shuffleArray((float[])arr, random);
        } else if (arr instanceof double[]) {
            ArrayUtils.shuffleArray((double[])arr, random);
        } else if (arr instanceof char[]) {
            ArrayUtils.shuffleArray((char[])arr, random);
        } else if (arr instanceof boolean[]) {
            ArrayUtils.shuffleArray((boolean[])arr, random);
        } else {
            throw new IllegalArgumentException("Not an array: " + arr);
        }
    }

    private static void shuffleArray(Object[] arr, Random random) {
        for (int i = 0; i < arr.length; ++i) {
            int r = random.intRange(0, i);
            Object tmp = arr[i];
            arr[i] = arr[r];
            arr[r] = tmp;
        }
    }

    private static void shuffleArray(byte[] arr, Random random) {
        for (int i = 0; i < arr.length; ++i) {
            int r = random.intRange(0, i);
            byte tmp = arr[i];
            arr[i] = arr[r];
            arr[r] = tmp;
        }
    }

    private static void shuffleArray(short[] arr, Random random) {
        for (int i = 0; i < arr.length; ++i) {
            int r = random.intRange(0, i);
            short tmp = arr[i];
            arr[i] = arr[r];
            arr[r] = tmp;
        }
    }

    private static void shuffleArray(int[] arr, Random random) {
        for (int i = 0; i < arr.length; ++i) {
            int r = random.intRange(0, i);
            int tmp = arr[i];
            arr[i] = arr[r];
            arr[r] = tmp;
        }
    }

    private static void shuffleArray(long[] arr, Random random) {
        for (int i = 0; i < arr.length; ++i) {
            int r = random.intRange(0, i);
            long tmp = arr[i];
            arr[i] = arr[r];
            arr[r] = tmp;
        }
    }

    private static void shuffleArray(float[] arr, Random random) {
        for (int i = 0; i < arr.length; ++i) {
            int r = random.intRange(0, i);
            float tmp = arr[i];
            arr[i] = arr[r];
            arr[r] = tmp;
        }
    }

    private static void shuffleArray(double[] arr, Random random) {
        for (int i = 0; i < arr.length; ++i) {
            int r = random.intRange(0, i);
            double tmp = arr[i];
            arr[i] = arr[r];
            arr[r] = tmp;
        }
    }

    private static void shuffleArray(char[] arr, Random random) {
        for (int i = 0; i < arr.length; ++i) {
            int r = random.intRange(0, i);
            char tmp = arr[i];
            arr[i] = arr[r];
            arr[r] = tmp;
        }
    }

    private static void shuffleArray(boolean[] arr, Random random) {
        for (int i = 0; i < arr.length; ++i) {
            int r = random.intRange(0, i);
            boolean tmp = arr[i];
            arr[i] = arr[r];
            arr[r] = tmp;
        }
    }

    private ArrayUtils() {
    }
}

