/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.instancio.spi.InstancioServiceProvider;

public final class ProviderEntry<P> {
    private final Class<? extends InstancioServiceProvider> instancioProviderClass;
    private final P provider;

    private ProviderEntry(Class<? extends InstancioServiceProvider> instancioProviderClass, P provider) {
        this.instancioProviderClass = instancioProviderClass;
        this.provider = provider;
    }

    public static <P> List<ProviderEntry<P>> from(List<InstancioServiceProvider> instancioServiceProviders, Function<InstancioServiceProvider, P> fn) {
        ArrayList<ProviderEntry<P>> results = new ArrayList<ProviderEntry<P>>();
        for (InstancioServiceProvider it : instancioServiceProviders) {
            P provider = fn.apply(it);
            if (provider == null) continue;
            results.add(new ProviderEntry<P>(it.getClass(), provider));
        }
        return Collections.unmodifiableList(results);
    }

    public Class<? extends InstancioServiceProvider> getInstancioProviderClass() {
        return this.instancioProviderClass;
    }

    public P getProvider() {
        return this.provider;
    }
}

