/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Field;
import java.util.Objects;
import org.instancio.Scope;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public final class ScopeImpl
implements Scope {
    private final Class<?> targetClass;
    private final String fieldName;
    private final Integer depth;

    public ScopeImpl(@Nullable Class<?> targetClass, @Nullable String fieldName, @Nullable Integer depth) {
        this.targetClass = targetClass;
        this.fieldName = fieldName;
        this.depth = depth;
    }

    public ScopeImpl(@Nullable Class<?> targetClass, @Nullable String fieldName) {
        this(targetClass, fieldName, null);
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public boolean isFieldScope() {
        return this.fieldName != null;
    }

    public Field resolveField() {
        Verify.state(this.isFieldScope(), "Invalid call to resolve field on Class scope: %s", this);
        return ReflectionUtils.getField(this.targetClass, this.fieldName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScopeImpl)) {
            return false;
        }
        ScopeImpl scope = (ScopeImpl)o;
        return Objects.equals(this.targetClass, scope.targetClass) && Objects.equals(this.fieldName, scope.fieldName) && Objects.equals(this.depth, scope.depth);
    }

    public int hashCode() {
        int result = this.targetClass == null ? 0 : this.targetClass.hashCode();
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.depth == null ? 0 : this.depth.hashCode());
        return result;
    }

    public String toString() {
        String s = "scope(" + this.targetClass.getSimpleName();
        if (this.fieldName != null) {
            s = s + ", \"" + this.fieldName + '\"';
        }
        if (this.depth != null) {
            s = s + ", atDepth(" + this.depth + ')';
        }
        return s + ')';
    }
}

