/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Optional;
import org.instancio.exception.InstancioException;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeContext;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.PredefinedNodeCreator;
import org.instancio.internal.nodes.TypeHelper;
import org.instancio.internal.nodes.resolvers.NodeKindResolverFacade;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeCreator {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCreator.class);
    private final PredefinedNodeCreator predefinedNodeCreator;
    private final NodeContext nodeContext;
    private final TypeHelper typeHelper;
    private final NodeKindResolverFacade nodeKindResolverFacade;

    NodeCreator(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
        this.typeHelper = new TypeHelper(nodeContext);
        this.nodeKindResolverFacade = new NodeKindResolverFacade(nodeContext.getContainerFactories());
        this.predefinedNodeCreator = new PredefinedNodeCreator(nodeContext, this.nodeKindResolverFacade);
    }

    @Nullable
    InternalNode createNode(@NotNull Type type, @Nullable Field field, @Nullable InternalNode parent) {
        InternalNode node;
        InternalNode template;
        Verify.notNull(type, "'type' is null", new Object[0]);
        if (parent != null && parent.getDepth() >= this.nodeContext.getMaxDepth()) {
            LOG.trace("Maximum depth ({}) reached {}", (Object)this.nodeContext.getMaxDepth(), (Object)parent);
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating node for: {}", (Object)Format.withoutPackage(type));
        }
        if ((template = this.predefinedNodeCreator.createFromTemplate(type, field, parent)) != null) {
            node = template;
        } else if (type instanceof Class) {
            node = this.fromClass((Class)type, field, parent);
        } else if (type instanceof ParameterizedType) {
            node = this.fromParameterizedType((ParameterizedType)type, field, parent);
        } else if (type instanceof TypeVariable) {
            node = this.fromTypeVariable((TypeVariable)type, field, parent);
        } else if (type instanceof WildcardType) {
            node = this.fromWildcardType((WildcardType)type, field, parent);
        } else if (type instanceof GenericArrayType) {
            node = this.fromGenericArrayNode((GenericArrayType)type, field, parent);
        } else {
            throw new InstancioException("Unsupported type: " + type.getClass());
        }
        if (node != null && this.nodeContext.isIgnored(node)) {
            return node.toBuilder().nodeKind(NodeKind.IGNORED).build();
        }
        LOG.trace("Created node {} for type {}", (Object)node, (Object)type);
        return node;
    }

    private InternalNode fromWildcardType(WildcardType type, @Nullable Field field, @Nullable InternalNode parent) {
        return this.createNode(type.getUpperBounds()[0], field, parent);
    }

    private InternalNode fromTypeVariable(TypeVariable<?> type, @Nullable Field field, @Nullable InternalNode parent) {
        Type resolvedType = this.typeHelper.resolveTypeVariable(type, parent);
        if (resolvedType == null) {
            LOG.warn("Unable to resolve type variable '{}'. Parent: {}", type, (Object)parent);
            return null;
        }
        return this.createNode(resolvedType, field, parent);
    }

    private Optional<Class<?>> resolveSubtype(InternalNode node) {
        Optional<Class<?>> subtype = this.nodeContext.getSubtype(node);
        if (subtype.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resolved subtype: {} -> {}", (Object)node.getRawType().getName(), (Object)subtype.get().getName());
            }
            return subtype;
        }
        return Optional.ofNullable(NodeCreator.resolveSubtypeFromAncestors(node));
    }

    private static Class<?> resolveSubtypeFromAncestors(InternalNode node) {
        for (InternalNode next = node; next != null; next = next.getParent()) {
            Type actualType = next.getTypeMap().getActualType(node.getRawType());
            if (actualType == null) continue;
            return TypeUtils.getRawType(actualType);
        }
        return null;
    }

    private InternalNode createNodeWithSubtypeMapping(Type type, @Nullable Field field, @Nullable InternalNode parent) {
        Class rawType = TypeUtils.getRawType(type);
        InternalNode node = InternalNode.builder().nodeContext(this.nodeContext).type(type).rawType(rawType).targetClass(rawType).field(field).parent(parent).nodeKind(this.getNodeKind(rawType)).build();
        Class targetClass = this.resolveSubtype(node).orElse(rawType);
        Map<Type, Type> genericSuperclassTypeMap = this.typeHelper.createSuperclassTypeMap(targetClass);
        if (!genericSuperclassTypeMap.isEmpty()) {
            node = node.toBuilder().additionalTypeMap(genericSuperclassTypeMap).build();
        }
        if (rawType != targetClass && !targetClass.isEnum() && !rawType.isPrimitive()) {
            ApiValidator.validateSubtype(rawType, targetClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Subtype mapping '{}' to '{}'", (Object)Format.withoutPackage(rawType), (Object)Format.withoutPackage(targetClass));
            }
            return node.toBuilder().targetClass(targetClass).nodeKind(this.getNodeKind(targetClass)).additionalTypeMap(this.typeHelper.createBridgeTypeMap(rawType, targetClass)).build();
        }
        return node;
    }

    private InternalNode fromClass(Class<?> type, @Nullable Field field, @Nullable InternalNode parent) {
        InternalNode node = this.createNodeWithSubtypeMapping(type, field, parent);
        return node.hasAncestorWithSameTargetType() ? node.toBuilder().cyclic().build() : node;
    }

    private NodeKind getNodeKind(Class<?> rawType) {
        return this.nodeKindResolverFacade.getNodeKind(rawType);
    }

    private InternalNode fromParameterizedType(ParameterizedType type, @Nullable Field field, @Nullable InternalNode parent) {
        InternalNode node = this.createNodeWithSubtypeMapping(type, field, parent);
        return node.hasAncestorWithSameTargetType() ? node.toBuilder().cyclic().build() : node;
    }

    private InternalNode fromGenericArrayNode(GenericArrayType type, @Nullable Field field, @Nullable InternalNode parent) {
        Type gcType = type.getGenericComponentType();
        if (gcType instanceof TypeVariable) {
            gcType = this.typeHelper.resolveTypeVariable((TypeVariable)gcType, parent);
        }
        return this.createArrayNodeWithSubtypeMapping(type, gcType, field, parent);
    }

    private InternalNode createArrayNodeWithSubtypeMapping(Type arrayType, Type genericComponentType, @Nullable Field field, @Nullable InternalNode parent) {
        Class rawComponentType = TypeUtils.getRawType(genericComponentType);
        InternalNode node = InternalNode.builder().nodeContext(this.nodeContext).type(arrayType).rawType(TypeUtils.getArrayClass(rawComponentType)).targetClass(TypeUtils.getArrayClass(rawComponentType)).field(field).parent(parent).nodeKind(NodeKind.ARRAY).build();
        Class targetClass = this.resolveSubtype(node).orElse(rawComponentType);
        Class<?> targetClassComponentType = targetClass.getComponentType();
        if (!rawComponentType.isPrimitive() && targetClassComponentType != null && rawComponentType != targetClassComponentType) {
            ApiValidator.validateSubtype(rawComponentType, targetClassComponentType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Subtype mapping '{}' to '{}'", (Object)Format.withoutPackage(rawComponentType), (Object)Format.withoutPackage(targetClass));
            }
            Map<Type, Type> typeMapForSubtype = this.typeHelper.createBridgeTypeMap(rawComponentType, targetClassComponentType);
            typeMapForSubtype.put(rawComponentType, targetClassComponentType);
            return node.toBuilder().targetClass(targetClass).additionalTypeMap(typeMapForSubtype).build();
        }
        return node;
    }
}

