/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import java.util.Optional;
import org.instancio.generator.Generator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.handlers.UserSuppliedGeneratorProcessor;
import org.instancio.internal.instantiation.Instantiator;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

public class UserSuppliedGeneratorHandler
implements NodeHandler {
    private final ModelContext<?> modelContext;
    private final UserSuppliedGeneratorProcessor userSuppliedGeneratorProcessor;

    public UserSuppliedGeneratorHandler(ModelContext<?> modelContext, GeneratorResolver generatorResolver, Instantiator instantiator) {
        this.modelContext = modelContext;
        this.userSuppliedGeneratorProcessor = new UserSuppliedGeneratorProcessor(modelContext, generatorResolver, instantiator);
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        Optional<Generator<?>> generatorOpt = this.modelContext.getGenerator(node);
        if (!generatorOpt.isPresent()) {
            return GeneratorResult.emptyResult();
        }
        return this.userSuppliedGeneratorProcessor.getGeneratorResult(node, generatorOpt.get());
    }
}

