/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.checksum;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.checksum.BaseModCheckGenerator;
import org.instancio.internal.generator.specs.InternalLengthGeneratorSpec;
import org.instancio.internal.util.Constants;

abstract class VariableLengthModCheckGenerator
extends BaseModCheckGenerator
implements InternalLengthGeneratorSpec<String> {
    private static final int DEFAULT_SIZE = 16;
    private int minSize = 16;
    private int maxSize = 16;
    private int startIndex;
    private int endIndex = -1;
    private int checkDigitIndex = -1;
    private int size;

    protected VariableLengthModCheckGenerator(GeneratorContext context) {
        super(context);
    }

    public VariableLengthModCheckGenerator startIndex(int idx) {
        ApiValidator.isTrue(idx >= 0, "start index must not be negative: %s", idx);
        this.startIndex = idx;
        return this;
    }

    public VariableLengthModCheckGenerator endIndex(int idx) {
        ApiValidator.isTrue(idx >= 0, "end index must not be negative: %s", idx);
        this.endIndex = idx == Integer.MAX_VALUE ? -1 : idx;
        return this;
    }

    public VariableLengthModCheckGenerator checkDigitIndex(int idx) {
        ApiValidator.isTrue(idx >= 0, "check digit index must not be negative: %s", idx);
        this.checkDigitIndex = idx;
        return this;
    }

    public VariableLengthModCheckGenerator length(int length) {
        ApiValidator.isTrue(length > 1, "number length must be greater than 1, but was: %s", length);
        this.minSize = length;
        this.maxSize = length;
        return this;
    }

    public VariableLengthModCheckGenerator length(int min, int max) {
        ApiValidator.isTrue(min > 0 && max > 1, "number length must be greater than 1, but was: length(%s, %s)", min, max);
        ApiValidator.isTrue(min <= max, "min must be less than or equal to max", new Object[0]);
        this.minSize = min;
        this.maxSize = max;
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        this.size = random.intRange(this.minSize, this.maxSize);
        this.endIndex = this.endIndex == -1 ? this.size - 1 : this.endIndex;
        this.checkDigitIndex = this.checkDigitIndex == -1 ? this.endIndex : this.checkDigitIndex;
        this.validateCheckDigit();
        this.endIndex = this.endIndex == this.checkDigitIndex ? this.endIndex - 1 : this.endIndex;
        this.size = Math.max(this.checkDigitIndex + 1, Math.max(this.size, this.endIndex + 1));
        return super.tryGenerateNonNull(random);
    }

    private void validateCheckDigit() {
        boolean isValidCheckDigit = this.checkDigitIndex >= 0 && (this.checkDigitIndex < this.startIndex || this.checkDigitIndex >= this.endIndex);
        ApiValidator.isTrue(isValidCheckDigit, this::getCheckDigitErrorMessage);
    }

    private String getCheckDigitErrorMessage() {
        return "checkDigitIndex must satisfy condition:" + Constants.NL + "  ->  checkDigitIndex >= 0 && (checkDigitIndex < startIndex || checkDigitIndex >= endIndex)" + Constants.NL + Constants.NL + "Actual values were:" + Constants.NL + "  -> startIndex .......: " + this.startIndex + Constants.NL + "  -> endIndex .........: " + this.endIndex + Constants.NL + "  -> checkDigitIndex ..: " + this.checkDigitIndex + Constants.NL;
    }

    @Override
    protected int prefixLength() {
        return this.startIndex;
    }

    @Override
    protected int payloadLength() {
        return this.endIndex - this.startIndex + 1;
    }

    @Override
    protected int checkPosition() {
        return this.checkDigitIndex;
    }

    @Override
    protected int suffixLength() {
        return this.size - this.endIndex - 1;
    }
}

