/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import java.lang.reflect.Field;
import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.FieldAssigner;
import org.instancio.internal.assigners.MethodAssigner;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.SystemProperties;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;

public class AssignerImpl
implements Assigner {
    private final Assigner delegate;
    private final boolean overwriteExistingValues;

    public AssignerImpl(ModelContext<?> context) {
        this.delegate = AssignerImpl.resolveAssigner(context);
        this.overwriteExistingValues = context.getSettings().get(Keys.OVERWRITE_EXISTING_VALUES);
    }

    @Override
    public void assign(InternalNode node, Object target, Object value) {
        Field field = node.getField();
        if (this.overwriteExistingValues || !ReflectionUtils.hasNonNullOrNonDefaultPrimitiveValue(field, target)) {
            this.delegate.assign(node, target, value);
        }
    }

    private static Assigner resolveAssigner(ModelContext<?> context) {
        Settings settings = context.getSettings();
        AssignmentType defaultAssignment = settings.get(Keys.ASSIGNMENT_TYPE);
        AssignmentType assignment = ObjectUtils.defaultIfNull(SystemProperties.getAssignmentType(), defaultAssignment);
        if (assignment == AssignmentType.FIELD) {
            return new FieldAssigner(settings);
        }
        if (assignment == AssignmentType.METHOD) {
            return new MethodAssigner(settings, context.getServiceProviders().getSetterMethodResolvers());
        }
        throw Fail.withFataInternalError("Invalid assignment type: %s", new Object[]{assignment});
    }
}

