/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.instancio.internal.annotation.GetterMethodResolver;
import org.instancio.internal.nodes.InternalNode;

class GetterMethodResolverImpl
implements GetterMethodResolver {
    GetterMethodResolverImpl() {
    }

    @Override
    public Method getGetter(InternalNode node) {
        String fieldName;
        Field field = node.getField();
        if (field == null) {
            return null;
        }
        Class<?> declaringClass = field.getDeclaringClass();
        Method method = GetterMethodResolverImpl.getMethod(declaringClass, GetterMethodResolverImpl.getMethodName("get", fieldName = field.getName()));
        if (method != null) {
            return method;
        }
        if ((field.getType() == Boolean.TYPE || field.getType() == Boolean.class) && (method = GetterMethodResolverImpl.getMethod(declaringClass, GetterMethodResolverImpl.getMethodName("is", fieldName))) != null) {
            return method;
        }
        return GetterMethodResolverImpl.getMethod(declaringClass, fieldName);
    }

    private static String getMethodName(String prefix, String fieldName) {
        String methodName = prefix + fieldName;
        char[] ch = methodName.toCharArray();
        int capitaliseIdx = prefix.length();
        ch[capitaliseIdx] = Character.toUpperCase(ch[capitaliseIdx]);
        return new String(ch);
    }

    private static Method getMethod(Class<?> declaringClass, String methodName) {
        try {
            return declaringClass.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

