/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import org.instancio.generator.AfterGenerate;
import org.instancio.internal.ArrayElementNodePopulationFilter;
import org.instancio.internal.FieldNodePopulationFilter;
import org.instancio.internal.NodePopulationFilter;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;

final class NodeFilter
implements NodePopulationFilter {
    private final NodePopulationFilter arrayNodeFilter = new ArrayElementNodePopulationFilter();
    private final NodePopulationFilter fieldNodeFilter = new FieldNodePopulationFilter();
    private final ModelContext<?> context;

    NodeFilter(ModelContext<?> context) {
        this.context = context;
    }

    @Override
    public boolean shouldSkip(InternalNode node, AfterGenerate afterGenerate, Object owner) {
        if (node.isIgnored() || afterGenerate == AfterGenerate.DO_NOT_MODIFY) {
            return true;
        }
        if (this.context.getGenerator(node).isPresent()) {
            return false;
        }
        InternalNode parent = node.getParent();
        NodePopulationFilter filter = parent.is(NodeKind.ARRAY) ? this.arrayNodeFilter : this.fieldNodeFilter;
        return filter.shouldSkip(node, afterGenerate, owner);
    }
}

