/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.Set;
import org.instancio.exception.InstancioTerminatingException;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.GeneratedObjectStore;
import org.instancio.internal.GeneratedPojoStore;
import org.instancio.internal.GeneratorSpecProcessor;
import org.instancio.internal.annotation.AnnotationGeneratorSpecProcessor;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.handlers.AssignmentNodeHandler;
import org.instancio.internal.handlers.CollectionNodeHandler;
import org.instancio.internal.handlers.InstantiatingHandler;
import org.instancio.internal.handlers.MapNodeHandler;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.handlers.UserSuppliedGeneratorHandler;
import org.instancio.internal.handlers.UsingGeneratorResolverHandler;
import org.instancio.internal.instantiation.Instantiator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeneratorFacade {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorFacade.class);
    private final ModelContext<?> context;
    private final NodeHandler[] nodeHandlers;
    private final AssignmentNodeHandler assignmentNodeHandler;
    private final NodeHandler userSuppliedGeneratorHandler;
    private final GeneratedPojoStore generatedPojoStore;

    GeneratorFacade(ModelContext<?> context, GeneratedObjectStore generatedObjectStore) {
        this.context = context;
        this.generatedPojoStore = GeneratedPojoStore.createStore(context);
        GeneratorContext generatorContext = new GeneratorContext(context.getSettings(), context.getRandom());
        GeneratorSpecProcessor specProcessor = AnnotationGeneratorSpecProcessor.create(context);
        GeneratorResolver generatorResolver = new GeneratorResolver(generatorContext, context.getServiceProviders().getGeneratorProviders());
        Instantiator instantiator = new Instantiator(context.getServiceProviders().getTypeInstantiators());
        this.assignmentNodeHandler = new AssignmentNodeHandler(context, generatedObjectStore, generatorResolver, instantiator);
        this.userSuppliedGeneratorHandler = new UserSuppliedGeneratorHandler(context, generatorResolver, instantiator);
        this.nodeHandlers = new NodeHandler[]{this.assignmentNodeHandler, this.userSuppliedGeneratorHandler, new UsingGeneratorResolverHandler(context, generatorResolver, specProcessor), new CollectionNodeHandler(context, specProcessor), new MapNodeHandler(context, specProcessor), new InstantiatingHandler(instantiator)};
    }

    Set<InternalAssignment> getUnresolvedAssignments() {
        return this.assignmentNodeHandler.getUnresolvedAssignments();
    }

    private boolean shouldReturnNullForNullable(InternalNode node) {
        boolean precondition = this.context.isNullable(node);
        return this.context.getRandom().diceRoll(precondition);
    }

    GeneratorResult generateNodeValue(InternalNode node) {
        try {
            GeneratorResult result = this.getGeneratorResult(node);
            this.generatedPojoStore.putValue(node, result);
            LOG.trace("{} - {}", (Object)node, (Object)result);
            return result;
        }
        catch (InstancioTerminatingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String msg = String.format("exception thrown by a custom Generator or Supplier%n%n -> Could not generate value for: %s (depth=%s)%n%n%s", node.toDisplayString(), node.getDepth(), Format.nodePathToRoot(node, "    "));
            throw Fail.withUsageError(msg, ex);
        }
    }

    private GeneratorResult getGeneratorResult(InternalNode node) {
        GeneratorResult result = GeneratorResult.emptyResult();
        if (node.isIgnored()) {
            result = GeneratorResult.ignoredResult();
        } else if (this.shouldReturnNullForNullable(node)) {
            result = GeneratorResult.nullResult();
        } else if (node.isCyclic()) {
            result = this.assignmentNodeHandler.getResult(node);
            if (result.isEmpty()) {
                result = this.userSuppliedGeneratorHandler.getResult(node);
            }
            if (result.isEmpty()) {
                result = this.generatedPojoStore.getParentObject(node);
            }
        } else {
            NodeHandler handler;
            NodeHandler[] nodeHandlerArray = this.nodeHandlers;
            int n = nodeHandlerArray.length;
            for (int i = 0; i < n && (result = (handler = nodeHandlerArray[i]).getResult(node)).isEmpty() && !result.isDelayed(); ++i) {
            }
        }
        return result;
    }
}

