/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.instancio.Assignment;
import org.instancio.GeneratorSpecProvider;
import org.instancio.InstancioApi;
import org.instancio.Model;
import org.instancio.OnCompleteCallback;
import org.instancio.Result;
import org.instancio.TargetSelector;
import org.instancio.TypeTokenSupplier;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.InstancioEngine;
import org.instancio.internal.InternalModel;
import org.instancio.internal.context.ModelContext;
import org.instancio.settings.Settings;

public class ApiImpl<T>
implements InstancioApi<T> {
    private final ModelContext.Builder<T> modelContextBuilder;

    public ApiImpl(Type klass) {
        this.modelContextBuilder = ModelContext.builder(klass);
    }

    public ApiImpl(TypeTokenSupplier<T> typeToken) {
        this.modelContextBuilder = ModelContext.builder(ApiValidator.validateTypeToken(typeToken));
    }

    public ApiImpl(Model<T> model) {
        InternalModel suppliedModel = (InternalModel)model;
        ModelContext suppliedContext = suppliedModel.getModelContext();
        this.modelContextBuilder = suppliedContext.toBuilder();
    }

    protected final void addTypeParameters(Type ... types) {
        this.modelContextBuilder.withRootTypeParameters(Arrays.asList(types));
    }

    @Override
    public InstancioApi<T> ignore(TargetSelector selector) {
        this.modelContextBuilder.withIgnored(selector);
        return this;
    }

    @Override
    public <V> InstancioApi<T> generate(TargetSelector selector, GeneratorSpecProvider<V> gen) {
        ApiValidator.validateGenerateSecondArgument(gen);
        this.modelContextBuilder.withGeneratorSpec(selector, gen);
        return this;
    }

    @Override
    public <V> InstancioApi<T> generate(TargetSelector selector, GeneratorSpec<V> spec) {
        ApiValidator.validateGenerateSecondArgument(spec);
        this.modelContextBuilder.withGenerator(selector, (Generator)spec);
        return this;
    }

    @Override
    public <V> InstancioApi<T> onComplete(TargetSelector selector, OnCompleteCallback<V> callback) {
        this.modelContextBuilder.withOnCompleteCallback(selector, callback);
        return this;
    }

    @Override
    public <V> InstancioApi<T> set(TargetSelector selector, V value) {
        this.modelContextBuilder.withSupplier(selector, () -> value);
        return this;
    }

    @Override
    public <V> InstancioApi<T> supply(TargetSelector selector, Generator<V> generator) {
        ApiValidator.validateGeneratorNotNull(generator);
        this.modelContextBuilder.withGenerator(selector, generator);
        return this;
    }

    @Override
    public <V> InstancioApi<T> supply(TargetSelector selector, Supplier<V> supplier) {
        ApiValidator.validateSupplierNotNull(supplier);
        this.modelContextBuilder.withSupplier(selector, supplier);
        return this;
    }

    @Override
    public InstancioApi<T> subtype(TargetSelector selector, Class<?> subtype) {
        this.modelContextBuilder.withSubtype(selector, subtype);
        return this;
    }

    @Override
    public InstancioApi<T> assign(Assignment ... assignments) {
        ApiValidator.notNull(assignments, "assignments array must not be null", new Object[0]);
        this.modelContextBuilder.withAssignments(assignments);
        return this;
    }

    @Override
    public InstancioApi<T> withSeed(long seed) {
        this.modelContextBuilder.withSeed(seed);
        return this;
    }

    @Override
    public InstancioApi<T> withMaxDepth(int maxDepth) {
        ApiValidator.isTrue(maxDepth >= 0, "Maximum depth must not be negative: %s", maxDepth);
        this.modelContextBuilder.withMaxDepth(maxDepth);
        return this;
    }

    @Override
    public InstancioApi<T> withNullable(TargetSelector selector) {
        this.modelContextBuilder.withNullable(selector);
        return this;
    }

    @Override
    public InstancioApi<T> withSettings(Settings settings) {
        this.modelContextBuilder.withSettings(settings);
        return this;
    }

    @Override
    public InstancioApi<T> lenient() {
        this.modelContextBuilder.lenient();
        return this;
    }

    @Override
    public InstancioApi<T> verbose() {
        this.modelContextBuilder.verbose();
        return this;
    }

    @Override
    public Model<T> toModel() {
        return this.createModel();
    }

    @Override
    public T create() {
        return this.createRootObject(this.createModel());
    }

    @Override
    public Result<T> asResult() {
        InternalModel<T> model = this.createModel();
        long seed = model.getModelContext().getRandom().getSeed();
        return new Result<T>(this.createRootObject(model), seed);
    }

    @Override
    public Stream<T> stream() {
        InternalModel<T> model = this.createModel();
        return Stream.generate(() -> this.createRootObject(model));
    }

    private T createRootObject(InternalModel<T> model) {
        return new InstancioEngine(model).createRootObject();
    }

    private InternalModel<T> createModel() {
        return new InternalModel<T>(this.modelContextBuilder.build());
    }
}

