/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tree.impl;

import java.util.Map;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.NodeNotExistsException;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.impl.NodeImpl;
import org.infinispan.tree.impl.NodeKey;
import org.infinispan.tree.impl.TreeStructureSupport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TreeCacheImpl<K, V>
extends TreeStructureSupport
implements TreeCache<K, V> {
    private static final Log log = LogFactory.getLog(TreeCacheImpl.class);
    private static final boolean trace = log.isTraceEnabled();

    public TreeCacheImpl(Cache<?, ?> cache) {
        this(cache.getAdvancedCache());
    }

    public TreeCacheImpl(AdvancedCache<?, ?> cache) {
        super(cache, cache.getBatchContainer());
        if (cache.getCacheConfiguration().indexing().index().isEnabled()) {
            throw new CacheConfigurationException("TreeCache cannot be used with a Cache instance configured to use indexing!");
        }
        TreeCacheImpl.assertBatchingSupported((Configuration)cache.getCacheConfiguration());
        this.createRoot();
    }

    @Override
    public Node<K, V> getRoot() {
        return this.getRoot(this.cache);
    }

    @Override
    public Node<K, V> getRoot(Flag ... flags) {
        return this.getRoot(this.cache.withFlags(flags));
    }

    private Node<K, V> getRoot(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache) {
        return new NodeImpl(Fqn.ROOT, cache, this.batchContainer);
    }

    @Override
    public V put(String fqn, K key, V value) {
        return this.put(this.cache, Fqn.fromString(fqn), key, value);
    }

    @Override
    public V put(String fqn, K key, V value, Flag ... flags) {
        return this.put(this.cache.withFlags(flags), Fqn.fromString(fqn), key, value);
    }

    @Override
    public void put(Fqn fqn, Map<? extends K, ? extends V> data) {
        this.put(this.cache, fqn, data);
    }

    @Override
    public void put(Fqn fqn, Map<? extends K, ? extends V> data, Flag ... flags) {
        this.put(this.cache.withFlags(flags), fqn, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn fqn, Map<? extends K, ? extends V> data) {
        this.startAtomic();
        try {
            Node<? extends K, ? extends V> n = this.getNode(cache, fqn);
            if (n == null) {
                this.createNodeInCache(cache, fqn);
            }
            n = this.getNode(cache, fqn);
            n.putAll(data);
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void put(String fqn, Map<? extends K, ? extends V> data) {
        this.put(this.cache, Fqn.fromString(fqn), data);
    }

    @Override
    public void put(String fqn, Map<? extends K, ? extends V> data, Flag ... flags) {
        this.put(this.cache.withFlags(flags), Fqn.fromString(fqn), data);
    }

    @Override
    public V remove(Fqn fqn, K key) {
        return this.remove(this.cache, fqn, key);
    }

    @Override
    public V remove(Fqn fqn, K key, Flag ... flags) {
        return this.remove(this.cache.withFlags(flags), fqn, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V remove(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn fqn, K key) {
        this.startAtomic();
        try {
            AtomicMap map = this.getAtomicMap(cache, new NodeKey(fqn, NodeKey.Type.DATA));
            Object object = map == null ? null : map.remove(key);
            return (V)object;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V remove(String fqn, K key) {
        return this.remove(this.cache, Fqn.fromString(fqn), key);
    }

    @Override
    public V remove(String fqn, K key, Flag ... flags) {
        return this.remove(this.cache.withFlags(flags), Fqn.fromString(fqn), key);
    }

    @Override
    public boolean removeNode(Fqn fqn) {
        return this.removeNode(this.cache, fqn);
    }

    @Override
    public boolean removeNode(Fqn fqn, Flag ... flags) {
        return this.removeNode(this.cache.withFlags(flags), fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeNode(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn fqn) {
        boolean result;
        if (fqn.isRoot()) {
            return false;
        }
        this.startAtomic();
        try {
            Node<K, V> n;
            if (trace) {
                log.tracef("About to remove node %s", (Object)fqn);
            }
            result = (n = this.getNode(cache, fqn.getParent())) != null && n.removeChild(fqn.getLastElement());
        }
        finally {
            this.endAtomic();
        }
        if (trace) {
            log.trace((Object)"Node successfully removed");
        }
        return result;
    }

    @Override
    public boolean removeNode(String fqn) {
        return this.removeNode(this.cache, Fqn.fromString(fqn));
    }

    @Override
    public boolean removeNode(String fqn, Flag ... flags) {
        return this.removeNode(this.cache.withFlags(flags), Fqn.fromString(fqn));
    }

    @Override
    public Node<K, V> getNode(Fqn fqn) {
        return this.getNode(this.cache, fqn);
    }

    @Override
    public Node<K, V> getNode(Fqn fqn, Flag ... flags) {
        return this.getNode(this.cache.withFlags(flags), fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<K, V> getNode(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn fqn) {
        this.startAtomic();
        try {
            if (this.exists(cache, fqn)) {
                NodeImpl nodeImpl = new NodeImpl(fqn, cache, this.batchContainer);
                return nodeImpl;
            }
            Node<K, V> node = null;
            return node;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Node<K, V> getNode(String fqn) {
        return this.getNode(this.cache, Fqn.fromString(fqn));
    }

    @Override
    public Node<K, V> getNode(String fqn, Flag ... flags) {
        return this.getNode(this.cache.withFlags(flags), Fqn.fromString(fqn));
    }

    @Override
    public V get(Fqn fqn, K key) {
        return this.get(this.cache, fqn, key);
    }

    @Override
    public V get(Fqn fqn, K key, Flag ... flags) {
        return this.get(this.cache.withFlags(flags), fqn, key);
    }

    private V get(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn fqn, K key) {
        AtomicMap m = this.getAtomicMap(cache, new NodeKey(fqn, NodeKey.Type.DATA));
        if (m == null) {
            return null;
        }
        return m.get(key);
    }

    @Override
    public boolean exists(String f) {
        return this.exists(this.cache, Fqn.fromString(f));
    }

    @Override
    public boolean exists(String fqn, Flag ... flags) {
        return this.exists(this.cache.withFlags(flags), Fqn.fromString(fqn));
    }

    @Override
    public boolean exists(Fqn fqn, Flag ... flags) {
        return this.exists(this.cache.withFlags(flags), fqn);
    }

    @Override
    public V get(String fqn, K key) {
        return this.get(this.cache, Fqn.fromString(fqn), key);
    }

    @Override
    public V get(String fqn, K key, Flag ... flags) {
        return this.get(this.cache.withFlags(flags), Fqn.fromString(fqn), key);
    }

    @Override
    public void move(Fqn nodeToMoveFqn, Fqn newParentFqn) throws NodeNotExistsException {
        this.move(this.cache, nodeToMoveFqn, newParentFqn);
    }

    @Override
    public void move(Fqn nodeToMoveFqn, Fqn newParentFqn, Flag ... flags) throws NodeNotExistsException {
        this.move(this.cache.withFlags(flags), nodeToMoveFqn, newParentFqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn nodeToMoveFqn, Fqn newParentFqn) throws NodeNotExistsException {
        if (trace) {
            log.tracef("Moving node '%s' to '%s'", (Object)nodeToMoveFqn, (Object)newParentFqn);
        }
        if (nodeToMoveFqn == null || newParentFqn == null) {
            throw new NullPointerException("Cannot accept null parameters!");
        }
        if (nodeToMoveFqn.getParent().equals(newParentFqn)) {
            if (trace) {
                log.trace((Object)"Not doing anything as this node is equal with its parent");
            }
            return;
        }
        this.startAtomic();
        boolean success = false;
        try {
            AdvancedCache cacheForWrite = cache.withFlags(Flag.FORCE_WRITE_LOCK);
            Node<K, V> parent = this.getNode(cacheForWrite, nodeToMoveFqn.getParent());
            if (!parent.hasChild(nodeToMoveFqn.getLastElement())) {
                if (trace) {
                    log.trace((Object)"The parent does not have the child that needs to be moved. Returning...");
                }
                return;
            }
            Node<K, V> nodeToMove = this.getNode(cacheForWrite, nodeToMoveFqn);
            if (nodeToMove == null) {
                if (trace) {
                    log.trace((Object)"Did not find the node that needs to be moved. Returning...");
                }
                return;
            }
            if (!this.exists(cacheForWrite, newParentFqn)) {
                this.createNodeInCache(cache, newParentFqn);
                if (trace) {
                    log.tracef("The new parent (%s) did not exists, was created", (Object)newParentFqn);
                }
            }
            Fqn newFqn = Fqn.fromRelativeElements(newParentFqn, nodeToMoveFqn.getLastElement());
            this.createNodeInCache(cache, newFqn);
            Node<K, V> newNode = this.getNode(cache, newFqn);
            Map<K, V> oldData = nodeToMove.getData();
            if (oldData != null && !oldData.isEmpty()) {
                newNode.putAll(oldData);
            }
            for (Object child : nodeToMove.getChildrenNames()) {
                if (trace) {
                    log.tracef("Moving child %s", child);
                }
                Fqn oldChildFqn = Fqn.fromRelativeElements(nodeToMoveFqn, child);
                this.move(cache, oldChildFqn, newFqn);
            }
            this.removeNode(cache, nodeToMoveFqn);
            success = true;
        }
        finally {
            if (success) {
                this.endAtomic();
            } else {
                this.failAtomic();
            }
        }
        log.tracef("Successfully moved node '%s' to '%s'", (Object)nodeToMoveFqn, (Object)newParentFqn);
    }

    @Override
    public void move(String nodeToMove, String newParent) throws NodeNotExistsException {
        this.move(this.cache, Fqn.fromString(nodeToMove), Fqn.fromString(newParent));
    }

    @Override
    public void move(String nodeToMove, String newParent, Flag ... flags) throws NodeNotExistsException {
        this.move(this.cache.withFlags(flags), Fqn.fromString(nodeToMove), Fqn.fromString(newParent));
    }

    @Override
    public Map<K, V> getData(Fqn fqn) {
        return this.getData(this.cache, fqn);
    }

    @Override
    public Map<K, V> getData(Fqn fqn, Flag ... flags) {
        return this.getData(this.cache.withFlags(flags), fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> getData(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn fqn) {
        this.startAtomic();
        try {
            Node<K, V> node = this.getNode(cache, fqn);
            if (node == null) {
                Map<K, V> map = null;
                return map;
            }
            Map<K, V> map = node.getData();
            return map;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Set<K> getKeys(String fqn) {
        return this.getKeys(this.cache, Fqn.fromString(fqn));
    }

    @Override
    public Set<K> getKeys(String fqn, Flag ... flags) {
        return this.getKeys(this.cache.withFlags(flags), Fqn.fromString(fqn));
    }

    @Override
    public Set<K> getKeys(Fqn fqn) {
        return this.getKeys(this.cache, fqn);
    }

    @Override
    public Set<K> getKeys(Fqn fqn, Flag ... flags) {
        return this.getKeys(this.cache.withFlags(flags), fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<K> getKeys(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn fqn) {
        this.startAtomic();
        try {
            Node<K, V> node = this.getNode(cache, fqn);
            if (node == null) {
                Set<K> set = null;
                return set;
            }
            Set<K> set = node.getKeys();
            return set;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public void clearData(String fqn) {
        this.clearData(this.cache, Fqn.fromString(fqn));
    }

    @Override
    public void clearData(String fqn, Flag ... flags) {
        this.clearData(this.cache.withFlags(flags), Fqn.fromString(fqn));
    }

    @Override
    public void clearData(Fqn fqn) {
        this.clearData(this.cache, fqn);
    }

    @Override
    public void clearData(Fqn fqn, Flag ... flags) {
        this.clearData(this.cache.withFlags(flags), fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn fqn) {
        this.startAtomic();
        try {
            Node<K, V> node = this.getNode(cache, fqn);
            if (node != null) {
                node.clearData();
            }
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public V put(Fqn fqn, K key, V value) {
        return this.put(this.cache, fqn, key, value);
    }

    @Override
    public V put(Fqn fqn, K key, V value, Flag ... flags) {
        return this.put(this.cache.withFlags(flags), fqn, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V put(AdvancedCache<NodeKey, AtomicMap<?, ?>> cache, Fqn fqn, K key, V value) {
        this.startAtomic();
        try {
            this.createNodeInCache(cache, fqn);
            AtomicMap<K, V> m = this.getAtomicMap(cache, new NodeKey(fqn, NodeKey.Type.DATA));
            V v = m.put(key, value);
            return v;
        }
        finally {
            this.endAtomic();
        }
    }

    @Override
    public Cache<?, ?> getCache() {
        return this.cache.getAdvancedCache();
    }

    public void start() throws CacheException {
        this.cache.start();
        this.createRoot();
    }

    public void stop() {
        this.cache.stop();
    }

    private void createRoot() {
        if (!this.exists(Fqn.ROOT)) {
            this.createNodeInCache(Fqn.ROOT);
        }
    }

    public String toString() {
        return this.cache.toString();
    }
}

