/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core;

import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.core.SecurityActions;
import org.infinispan.query.core.impl.EmbeddedQueryFactory;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.impl.QueryEngine;
import org.infinispan.query.core.impl.continuous.ContinuousQueryImpl;
import org.infinispan.query.core.impl.eventfilter.IckleCacheEventFilterConverter;
import org.infinispan.query.core.impl.eventfilter.IckleFilterAndConverter;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.util.logging.LogFactory;

public final class Search {
    private static final Log log = (Log)LogFactory.getLog(Search.class, Log.class);

    private Search() {
    }

    public static <K, V> CacheEventFilterConverter<K, V, ObjectFilter.FilterResult> makeFilter(String queryString) {
        return Search.makeFilter(queryString, null);
    }

    public static <K, V> CacheEventFilterConverter<K, V, ObjectFilter.FilterResult> makeFilter(String queryString, Map<String, Object> namedParameters) {
        IckleFilterAndConverter filterAndConverter = new IckleFilterAndConverter(queryString, namedParameters, ReflectionMatcher.class);
        return new IckleCacheEventFilterConverter(filterAndConverter);
    }

    public static <K, V> CacheEventFilterConverter<K, V, ObjectFilter.FilterResult> makeFilter(Query<?> query) {
        return Search.makeFilter(query.getQueryString(), query.getParameters());
    }

    public static QueryFactory getQueryFactory(Cache<?, ?> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter must not be null");
        }
        AdvancedCache advancedCache = cache.getAdvancedCache();
        if (advancedCache == null) {
            throw new IllegalArgumentException("The given cache must expose an AdvancedCache");
        }
        Search.checkBulkReadPermission(advancedCache);
        QueryEngine queryEngine = (QueryEngine)SecurityActions.getCacheComponentRegistry(advancedCache).getComponent(QueryEngine.class);
        if (queryEngine == null) {
            throw new IllegalStateException(QueryEngine.class.getName() + " not found in component registry");
        }
        return new EmbeddedQueryFactory(queryEngine);
    }

    public static <K, V> ContinuousQuery<K, V> getContinuousQuery(Cache<K, V> cache) {
        return new ContinuousQueryImpl<K, V>(cache);
    }

    private static void checkBulkReadPermission(AdvancedCache<?, ?> cache) {
        AuthorizationManager authorizationManager = SecurityActions.getCacheAuthorizationManager(cache);
        if (authorizationManager != null) {
            authorizationManager.checkPermission(AuthorizationPermission.BULK_READ);
        }
    }
}

