/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.marshall.core.ExternalPojo;

public final class ExternallyMarshallable {
    private static final List<String> whiteListClasses = new ArrayList<String>();

    private ExternallyMarshallable() {
    }

    public static void addToWhiteList(String type) {
        whiteListClasses.add(type);
    }

    public static boolean isAllowed(Object obj) {
        Class<?> clazz = obj.getClass();
        return ExternallyMarshallable.isAllowed(clazz);
    }

    public static boolean isAllowed(Class<?> clazz) {
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            if (clazz.isArray()) {
                return true;
            }
            throw new IllegalStateException("No package info for " + clazz + ", runtime-generated class?");
        }
        String pkgName = pkg.getName();
        boolean isBlackList = Serializable.class.isAssignableFrom(clazz) && ExternallyMarshallable.isMarshallablePackage(pkgName) && !ExternalPojo.class.isAssignableFrom(clazz) && !ExternallyMarshallable.isWhiteList(clazz.getName());
        return !isBlackList;
    }

    private static boolean isMarshallablePackage(String pkg) {
        return pkg.startsWith("java.") || pkg.startsWith("org.infinispan.") || pkg.startsWith("org.jgroups.") || pkg.startsWith("org.apache") || pkg.startsWith("org.jboss") || pkg.startsWith("com.arjuna");
    }

    private static boolean isWhiteList(String className) {
        return whiteListClasses.stream().anyMatch(className::contains);
    }

    static {
        whiteListClasses.add("Exception");
        whiteListClasses.add("$$Lambda$");
        whiteListClasses.add("java.lang.Class");
        whiteListClasses.add("java.time.Instant");
        whiteListClasses.add("org.hibernate.search.query.engine.impl.LuceneHSQuery");
        whiteListClasses.add("org.infinispan.distexec.RunnableAdapter");
        whiteListClasses.add("org.infinispan.jcache.annotation.DefaultCacheKey");
        whiteListClasses.add("org.infinispan.query.clustered.QueryResponse");
        whiteListClasses.add("org.infinispan.server.core.transport.NettyTransport$ConnectionAdderTask");
        whiteListClasses.add("org.infinispan.server.hotrod.CheckAddressTask");
        whiteListClasses.add("org.infinispan.server.infinispan.task.DistributedServerTask");
        whiteListClasses.add("org.infinispan.scripting.impl.DataType");
        whiteListClasses.add("org.infinispan.scripting.impl.DistributedScript");
        whiteListClasses.add("org.infinispan.stats.impl.ClusterCacheStatsImpl$DistributedCacheStatsCallable");
        whiteListClasses.add("org.infinispan.xsite.BackupSender$TakeSiteOfflineResponse");
        whiteListClasses.add("org.infinispan.xsite.BackupSender$BringSiteOnlineResponse");
        whiteListClasses.add("org.infinispan.xsite.XSiteAdminCommand$Status");
        whiteListClasses.add("org.infinispan.util.logging.events.EventLogLevel");
        whiteListClasses.add("org.infinispan.util.logging.events.EventLogCategory");
        whiteListClasses.add("java.util.Date");
        whiteListClasses.add("java.lang.Byte");
        whiteListClasses.add("java.lang.Integer");
        whiteListClasses.add("java.lang.Double");
        whiteListClasses.add("java.lang.Short");
        whiteListClasses.add("java.lang.Long");
        whiteListClasses.add("org.infinispan.test");
        whiteListClasses.add("org.infinispan.server.test");
        whiteListClasses.add("org.infinispan.it");
        whiteListClasses.add("org.infinispan.all");
        whiteListClasses.add("org.infinispan.query.api");
        whiteListClasses.add("org.jboss.as.quickstarts.datagrid");
    }
}

