/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.MeasurementType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;

@MBean(objectName="Activation", description="Component that handles activating entries that have been passivated to a CacheStore by loading them into memory.")
public class ActivationManagerImpl
implements ActivationManager {
    private static final Log log = LogFactory.getLog(ActivationManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final AtomicLong activations = new AtomicLong(0L);
    private CacheLoaderManager clm;
    private CacheStore store;
    private Configuration cfg;
    private boolean enabled;
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", writable=true)
    private boolean statisticsEnabled = false;

    @Inject
    public void inject(CacheLoaderManager clm, Configuration cfg) {
        this.clm = clm;
        this.cfg = cfg;
    }

    @Start(priority=10)
    public void start() {
        boolean bl = this.enabled = this.clm.isUsingPassivation() && !this.clm.isShared();
        if (this.enabled) {
            this.store = this.clm.getCacheStore();
            if (this.store == null) {
                throw new ConfigurationException("Passivation can only be used with a CacheLoader that implements CacheStore!");
            }
            this.statisticsEnabled = this.cfg.jmxStatistics().enabled();
        }
    }

    @Override
    public void activate(Object key) {
        if (this.enabled) {
            try {
                if (this.store.remove(key) && this.statisticsEnabled) {
                    this.activations.incrementAndGet();
                }
            }
            catch (CacheLoaderException e) {
                log.unableToRemoveEntryAfterActivation(key, e);
            }
        } else if (trace) {
            log.trace("Don't remove entry from shared cache store after activation.");
        }
    }

    @Override
    public long getActivationCount() {
        return this.activations.get();
    }

    @ManagedAttribute(description="Number of activation events")
    @Metric(displayName="Number of cache entries activated", measurementType=MeasurementType.TRENDSUP)
    public String getActivations() {
        if (!this.statisticsEnabled) {
            return "N/A";
        }
        return String.valueOf(this.getActivationCount());
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    @Operation(displayName="Reset statistics")
    public void resetStatistics() {
        this.activations.set(0L);
    }
}

