/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.remoting.transport.Address;

class OwnershipStatistics {
    private final Map<Address, Integer> nodes;
    private final int[] primaryOwned;
    private final int[] owned;

    public OwnershipStatistics(List<Address> nodes) {
        this.nodes = new HashMap<Address, Integer>(nodes.size());
        for (int i = 0; i < nodes.size(); ++i) {
            this.nodes.put(nodes.get(i), i);
        }
        this.primaryOwned = new int[nodes.size()];
        this.owned = new int[nodes.size()];
    }

    public OwnershipStatistics(DefaultConsistentHash ch, List<Address> nodes) {
        this(nodes);
        for (int i = 0; i < ch.getNumSegments(); ++i) {
            List<Address> owners = ch.locateOwnersForSegment(i);
            for (int j = 0; j < owners.size(); ++j) {
                Address address = owners.get(j);
                if (!nodes.contains(address)) continue;
                if (j == 0) {
                    this.incPrimaryOwned(address);
                }
                this.incOwned(address);
            }
        }
    }

    public OwnershipStatistics(OwnershipStatistics other) {
        this.nodes = new HashMap<Address, Integer>(other.nodes);
        this.primaryOwned = Arrays.copyOf(other.primaryOwned, other.primaryOwned.length);
        this.owned = Arrays.copyOf(other.owned, other.owned.length);
    }

    public int getPrimaryOwned(Address a) {
        Integer i = this.nodes.get(a);
        if (i == null) {
            return 0;
        }
        return this.primaryOwned[i];
    }

    public int getOwned(Address a) {
        Integer i = this.nodes.get(a);
        if (i == null) {
            return 0;
        }
        return this.owned[i];
    }

    public void incPrimaryOwned(Address a) {
        Integer i = this.nodes.get(a);
        if (i == null) {
            throw new IllegalArgumentException("Trying to modify statistics for a node that doesn't exist: " + a);
        }
        int n = i;
        this.primaryOwned[n] = this.primaryOwned[n] + 1;
    }

    public void incOwned(Address a) {
        Integer i = this.nodes.get(a);
        if (i == null) {
            throw new IllegalArgumentException("Trying to modify statistics for a node that doesn't exist: " + a);
        }
        int n = i;
        this.owned[n] = this.owned[n] + 1;
    }

    public void decPrimaryOwned(Address a) {
        Integer i = this.nodes.get(a);
        if (i == null) {
            throw new IllegalArgumentException("Trying to modify statistics for a node that doesn't exist: " + a);
        }
        int n = i;
        this.primaryOwned[n] = this.primaryOwned[n] - 1;
    }

    public void decOwned(Address a) {
        Integer i = this.nodes.get(a);
        if (i == null) {
            throw new IllegalArgumentException("Trying to modify statistics for a node that doesn't exist: " + a);
        }
        int n = i;
        this.owned[n] = this.owned[n] - 1;
    }
}

