/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.config.ConfigurationException;
import org.infinispan.configuration.Builder;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<StateTransferConfiguration> {
    private static final Log log = LogFactory.getLog(StateTransferConfigurationBuilder.class);
    private Boolean fetchInMemoryState = null;
    private Boolean waitForInitialStateTransferToComplete = null;
    private int chunkSize = 10000;
    private long timeout = TimeUnit.MINUTES.toMillis(4L);

    StateTransferConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public StateTransferConfigurationBuilder fetchInMemoryState(boolean b) {
        this.fetchInMemoryState = b;
        return this;
    }

    public StateTransferConfigurationBuilder waitForInitialStateTransferToComplete(boolean b) {
        this.waitForInitialStateTransferToComplete = b;
        return this;
    }

    public StateTransferConfigurationBuilder chunkSize(int i) {
        this.chunkSize = i;
        return this;
    }

    public StateTransferConfigurationBuilder timeout(long l) {
        this.timeout = l;
        return this;
    }

    public StateTransferConfigurationBuilder timeout(long l, TimeUnit unit) {
        return this.timeout(unit.toMillis(l));
    }

    @Override
    public void validate() {
        if (this.fetchInMemoryState != null && this.fetchInMemoryState.booleanValue() && this.getClusteringBuilder().cacheMode().isInvalidation()) {
            throw new ConfigurationException("Cache cannot use INVALIDATION mode and have fetchInMemoryState set to true.");
        }
        if (this.waitForInitialStateTransferToComplete != null && this.waitForInitialStateTransferToComplete.booleanValue() && !this.getClusteringBuilder().cacheMode().isReplicated() && !this.getClusteringBuilder().cacheMode().isDistributed()) {
            throw new ConfigurationException("waitForInitialStateTransferToComplete can be enabled only if cache mode is distributed or replicated.");
        }
    }

    @Override
    public StateTransferConfiguration create() {
        boolean _waitForInitialStateTransferToComplete;
        boolean _fetchInMemoryState;
        CacheMode cacheMode = this.getClusteringBuilder().cacheMode();
        if (this.fetchInMemoryState != null) {
            _fetchInMemoryState = this.fetchInMemoryState;
        } else if (cacheMode.isReplicated() || cacheMode.isDistributed()) {
            log.trace("Cache is distributed or replicated but state transfer was not defined, enabling it by default");
            _fetchInMemoryState = true;
        } else {
            _fetchInMemoryState = false;
        }
        if (this.waitForInitialStateTransferToComplete != null) {
            _waitForInitialStateTransferToComplete = this.waitForInitialStateTransferToComplete;
        } else if (cacheMode.isReplicated() || cacheMode.isDistributed()) {
            log.trace("Cache is distributed or replicated but waitForInitialStateTransferToComplete was not defined, enabling it by default");
            _waitForInitialStateTransferToComplete = true;
        } else {
            _waitForInitialStateTransferToComplete = false;
        }
        return new StateTransferConfiguration(_fetchInMemoryState, this.fetchInMemoryState, this.timeout, this.chunkSize, _waitForInitialStateTransferToComplete, this.waitForInitialStateTransferToComplete);
    }

    public StateTransferConfigurationBuilder read(StateTransferConfiguration template) {
        this.fetchInMemoryState = template.originalFetchInMemoryState();
        this.waitForInitialStateTransferToComplete = template.originalWaitForInitialStateTransferToComplete();
        this.timeout = template.timeout();
        this.chunkSize = template.chunkSize();
        return this;
    }

    public String toString() {
        return "StateTransferConfigurationBuilder{chunkSize=" + this.chunkSize + ", fetchInMemoryState=" + this.fetchInMemoryState + ", waitForInitialStateTransferToComplete=" + this.waitForInitialStateTransferToComplete + ", timeout=" + this.timeout + '}';
    }
}

