/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.concurrent.TimeUnit;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CreateCacheCommand
extends BaseRpcCommand {
    private static final Log log = LogFactory.getLog(CreateCacheCommand.class);
    public static final byte COMMAND_ID = 29;
    private EmbeddedCacheManager cacheManager;
    private String cacheNameToCreate;
    private String cacheConfigurationName;

    private CreateCacheCommand() {
        super(null);
    }

    public CreateCacheCommand(String ownerCacheName) {
        super(ownerCacheName);
    }

    public CreateCacheCommand(String ownerCacheName, String cacheNameToCreate, String cacheConfigurationName) {
        super(ownerCacheName);
        this.cacheNameToCreate = cacheNameToCreate;
        this.cacheConfigurationName = cacheConfigurationName;
    }

    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        Configuration cacheConfig = this.cacheManager.getCacheConfiguration(this.cacheConfigurationName);
        if (cacheConfig == null) {
            cacheConfig = new ConfigurationBuilder().clustering().stateTransfer().fetchInMemoryState(false).unsafe().unreliableReturnValues(true).expiration().lifespan(2L, TimeUnit.MINUTES).maxIdle(2L, TimeUnit.MINUTES).wakeUpInterval(30L, TimeUnit.SECONDS).enableReaper().clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(2).sync().transaction().transactionMode(TransactionMode.TRANSACTIONAL).syncCommitPhase(true).syncRollbackPhase(true).lockingMode(LockingMode.PESSIMISTIC).build();
            this.cacheManager.defineConfiguration(this.cacheNameToCreate, cacheConfig);
            log.debug("Using default tmp cache configuration, defined as " + this.cacheNameToCreate);
        }
        this.cacheManager.getCache(this.cacheNameToCreate);
        log.debug("Defined and started cache " + this.cacheNameToCreate);
        return true;
    }

    @Override
    public byte getCommandId() {
        return 29;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.cacheNameToCreate, this.cacheConfigurationName};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheConfigurationName == null ? 0 : this.cacheConfigurationName.hashCode());
        result = 31 * result + (this.cacheNameToCreate == null ? 0 : this.cacheNameToCreate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheCommand)) {
            return false;
        }
        CreateCacheCommand other = (CreateCacheCommand)obj;
        if (this.cacheConfigurationName == null ? other.cacheConfigurationName != null : !this.cacheConfigurationName.equals(other.cacheConfigurationName)) {
            return false;
        }
        return !(this.cacheNameToCreate == null ? other.cacheNameToCreate != null : !this.cacheNameToCreate.equals(other.cacheNameToCreate));
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 29) {
            throw new IllegalStateException("Invalid method id " + commandId + " but " + this.getClass() + " has id " + this.getCommandId());
        }
        int i = 0;
        this.cacheNameToCreate = (String)parameters[i++];
        this.cacheConfigurationName = (String)parameters[i++];
    }

    @Override
    public String toString() {
        return "CreateCacheCommand [cacheNameToCreate=" + this.cacheNameToCreate + ", cacheConfigurationName=" + this.cacheConfigurationName + "]";
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }
}

