/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationChildBuilder;
import org.infinispan.configuration.cache.EncodingConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.cache.InvocationBatchingConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.QueryConfigurationBuilder;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.infinispan.configuration.cache.StatisticsConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.TracingConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.cache.UnsafeConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class ConfigurationBuilder
implements ConfigurationChildBuilder {
    private final ClusteringConfigurationBuilder clustering;
    private final EncodingConfigurationBuilder encoding;
    private final ExpirationConfigurationBuilder expiration;
    private final QueryConfigurationBuilder query;
    private final IndexingConfigurationBuilder indexing;
    private final TracingConfigurationBuilder tracing;
    private final InvocationBatchingConfigurationBuilder invocationBatching;
    private final StatisticsConfigurationBuilder statistics;
    private final PersistenceConfigurationBuilder persistence;
    private final LockingConfigurationBuilder locking;
    private final SecurityConfigurationBuilder security;
    private final TransactionConfigurationBuilder transaction;
    private final UnsafeConfigurationBuilder unsafe;
    private final List<Builder<?>> modules = new ArrayList();
    private final SitesConfigurationBuilder sites;
    private final MemoryConfigurationBuilder memory;
    private final AttributeSet attributes = Configuration.attributeDefinitionSet();
    private boolean template = false;

    public ConfigurationBuilder() {
        this.clustering = new ClusteringConfigurationBuilder(this);
        this.encoding = new EncodingConfigurationBuilder(this);
        this.expiration = new ExpirationConfigurationBuilder(this);
        this.query = new QueryConfigurationBuilder(this);
        this.indexing = new IndexingConfigurationBuilder(this);
        this.tracing = new TracingConfigurationBuilder(this);
        this.invocationBatching = new InvocationBatchingConfigurationBuilder(this);
        this.statistics = new StatisticsConfigurationBuilder(this);
        this.persistence = new PersistenceConfigurationBuilder(this);
        this.locking = new LockingConfigurationBuilder(this);
        this.security = new SecurityConfigurationBuilder(this);
        this.transaction = new TransactionConfigurationBuilder(this);
        this.unsafe = new UnsafeConfigurationBuilder(this);
        this.sites = new SitesConfigurationBuilder(this);
        this.memory = new MemoryConfigurationBuilder(this);
    }

    @Override
    public ConfigurationBuilder simpleCache(boolean simpleCache) {
        this.attributes.attribute(Configuration.SIMPLE_CACHE).set((Object)simpleCache);
        return this;
    }

    @Override
    public boolean simpleCache() {
        return (Boolean)this.attributes.attribute(Configuration.SIMPLE_CACHE).get();
    }

    @Override
    public ClusteringConfigurationBuilder clustering() {
        return this.clustering;
    }

    @Override
    public EncodingConfigurationBuilder encoding() {
        return this.encoding;
    }

    @Override
    public ExpirationConfigurationBuilder expiration() {
        return this.expiration;
    }

    @Override
    public QueryConfigurationBuilder query() {
        return this.query;
    }

    @Override
    public IndexingConfigurationBuilder indexing() {
        return this.indexing;
    }

    @Override
    public TracingConfigurationBuilder tracing() {
        return this.tracing;
    }

    @Override
    public InvocationBatchingConfigurationBuilder invocationBatching() {
        return this.invocationBatching;
    }

    @Override
    public StatisticsConfigurationBuilder statistics() {
        return this.statistics;
    }

    @Override
    public PersistenceConfigurationBuilder persistence() {
        return this.persistence;
    }

    @Override
    public LockingConfigurationBuilder locking() {
        return this.locking;
    }

    @Override
    public SecurityConfigurationBuilder security() {
        return this.security;
    }

    @Override
    public TransactionConfigurationBuilder transaction() {
        return this.transaction;
    }

    @Override
    public UnsafeConfigurationBuilder unsafe() {
        return this.unsafe;
    }

    @Override
    public SitesConfigurationBuilder sites() {
        return this.sites;
    }

    @Override
    public MemoryConfigurationBuilder memory() {
        return this.memory;
    }

    public List<Builder<?>> modules() {
        return Collections.unmodifiableList(this.modules);
    }

    public ConfigurationBuilder clearModules() {
        this.modules.clear();
        return this;
    }

    public <T extends Builder<?>> T addModule(Class<T> klass) {
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(ConfigurationBuilder.class);
            Builder builder = (Builder)constructor.newInstance(this);
            this.modules.add(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate module configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    @Override
    public ConfigurationBuilder template(boolean template) {
        this.template = template;
        return this;
    }

    public boolean template() {
        return this.template;
    }

    public ConfigurationBuilder configuration(String baseConfigurationName) {
        this.attributes.attribute(Configuration.CONFIGURATION).set((Object)baseConfigurationName);
        return this;
    }

    public String configuration() {
        return (String)this.attributes.attribute(Configuration.CONFIGURATION).get();
    }

    public void validate() {
        if (((Boolean)this.attributes.attribute(Configuration.SIMPLE_CACHE).get()).booleanValue()) {
            this.validateSimpleCacheConfiguration();
        }
        ArrayList<RuntimeException> validationExceptions = new ArrayList<RuntimeException>();
        for (Builder builder : Arrays.asList(this.clustering, this.expiration, this.query, this.indexing, this.tracing, this.encoding, this.invocationBatching, this.statistics, this.persistence, this.locking, this.transaction, this.unsafe, this.sites, this.memory)) {
            try {
                builder.validate();
            }
            catch (RuntimeException e2) {
                validationExceptions.add(e2);
            }
        }
        for (Builder builder : this.modules) {
            try {
                builder.validate();
            }
            catch (RuntimeException e3) {
                validationExceptions.add(e3);
            }
        }
        CacheConfigurationException.fromMultipleRuntimeExceptions(validationExceptions).ifPresent(e -> {
            throw e;
        });
    }

    private void validateSimpleCacheConfiguration() {
        if (this.clustering().cacheMode().isClustered() || this.transaction.transactionMode() != null && this.transaction.transactionMode().isTransactional() || !this.persistence.stores().isEmpty() || this.invocationBatching.isEnabled() || this.indexing.enabled() || this.memory.create().storage() == StorageType.BINARY) {
            throw Log.CONFIG.notSupportedInSimpleCache();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        ArrayList<RuntimeException> validationExceptions = new ArrayList<RuntimeException>();
        for (ConfigurationChildBuilder configurationChildBuilder : Arrays.asList(this.clustering, this.expiration, this.query, this.indexing, this.tracing, this.invocationBatching, this.statistics, this.persistence, this.locking, this.transaction, this.unsafe, this.sites, this.security, this.memory)) {
            try {
                configurationChildBuilder.validate(globalConfig);
            }
            catch (RuntimeException e2) {
                validationExceptions.add(e2);
            }
        }
        CacheConfigurationException.fromMultipleRuntimeExceptions(validationExceptions).ifPresent(e -> {
            throw e;
        });
    }

    @Override
    public Configuration build() {
        return this.build(true);
    }

    public Configuration build(GlobalConfiguration globalConfiguration) {
        this.validate(globalConfiguration);
        return this.build(true);
    }

    public Configuration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        LinkedList<Object> modulesConfig = new LinkedList<Object>();
        for (Builder<?> module : this.modules) {
            modulesConfig.add(module.create());
        }
        return new Configuration(this.template, this.attributes.protect(), this.clustering.create(), this.expiration.create(), this.encoding.create(), this.query.create(), this.indexing.create(), this.tracing.create(), this.invocationBatching.create(), this.statistics.create(), this.persistence.create(), this.locking.create(), this.security.create(), this.transaction.create(), this.unsafe.create(), this.sites.create(), this.memory.create(), modulesConfig);
    }

    public ConfigurationBuilder read(Configuration template) {
        return this.read(template, Combine.DEFAULT);
    }

    public ConfigurationBuilder read(Configuration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.clustering.read(template.clustering(), combine);
        this.expiration.read(template.expiration(), combine);
        this.query.read(template.query(), combine);
        this.indexing.read(template.indexing(), combine);
        this.tracing.read((Object)template.tracing());
        this.invocationBatching.read(template.invocationBatching(), combine);
        this.statistics.read(template.statistics(), combine);
        this.persistence.read(template.persistence(), combine);
        this.locking.read(template.locking(), combine);
        this.security.read(template.security(), combine);
        this.transaction.read(template.transaction(), combine);
        this.unsafe.read(template.unsafe(), combine);
        this.sites.read(template.sites(), combine);
        this.memory.read(template.memory(), combine);
        this.encoding.read(template.encoding(), combine);
        this.template = template.isTemplate();
        for (Object c : template.modules().values()) {
            Object builder = this.addModule(ConfigurationUtils.builderFor(c));
            builder.read(c, combine);
        }
        return this;
    }

    public String toString() {
        return "ConfigurationBuilder{clustering=" + String.valueOf(this.clustering) + ", expiration=" + String.valueOf(this.expiration) + ", query=" + String.valueOf(this.query) + ", indexing=" + String.valueOf(this.indexing) + ", tracing=" + String.valueOf(this.tracing) + ", invocationBatching=" + String.valueOf(this.invocationBatching) + ", statistics=" + String.valueOf(this.statistics) + ", persistence=" + String.valueOf(this.persistence) + ", locking=" + String.valueOf(this.locking) + ", modules=" + String.valueOf(this.modules) + ", security=" + String.valueOf(this.security) + ", transaction=" + String.valueOf(this.transaction) + ", unsafe=" + String.valueOf(this.unsafe) + ", sites=" + String.valueOf(this.sites) + "}";
    }
}

