/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;

public class IracCleanupTombstoneCommand
extends XSiteReplicateCommand<Boolean> {
    public static final byte COMMAND_ID = 37;
    private Object key;
    private IracMetadata tombstone;

    public IracCleanupTombstoneCommand() {
        super((byte)37, null);
    }

    public IracCleanupTombstoneCommand(ByteString cacheName) {
        super((byte)37, cacheName);
    }

    public IracCleanupTombstoneCommand(ByteString cacheName, Object key, IracMetadata tombstone) {
        super((byte)37, cacheName);
        this.key = key;
        this.tombstone = tombstone;
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    public CompletionStage<Boolean> invokeAsync(ComponentRegistry registry) {
        if (this.tombstone == null) {
            return this.isKeyInIracManager(registry);
        }
        registry.getIracTombstoneCleaner().running().removeTombstone(this.key, this.tombstone);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 37;
    }

    @Override
    public CompletionStage<Boolean> performInLocalSite(ComponentRegistry registry, boolean preserveOrder) {
        DistributionInfo distribution = registry.getDistributionManager().getCacheTopology().getDistribution(this.key);
        if (distribution.isPrimary()) {
            return this.isKeyInIracManager(registry);
        }
        RpcManager manager = registry.getRpcManager().running();
        return manager.invokeCommand(distribution.primary(), (ReplicableCommand)this, new BooleanResponseCollector(), manager.getSyncRpcOptions());
    }

    @Override
    public CompletionStage<Boolean> performInLocalSite(BackupReceiver receiver, boolean preserveOrder) {
        throw new IllegalStateException("Should never be invoked!");
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        IracMetadata.writeTo(output, this.tombstone);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.tombstone = IracMetadata.readFrom(input);
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    @Override
    public String toString() {
        return "IracCleanupTombstoneCommand{cacheName=" + this.cacheName + ", key=" + Util.toStr((Object)this.key) + ", tombstone=" + this.tombstone + '}';
    }

    private CompletionStage<Boolean> isKeyInIracManager(ComponentRegistry registry) {
        return CompletableFutures.booleanStage(registry.getIracManager().running().containsKey(this.key));
    }

    private static final class BooleanResponseCollector
    extends ValidSingleResponseCollector<Boolean> {
        private BooleanResponseCollector() {
        }

        @Override
        protected Boolean withValidResponse(Address sender, ValidResponse response) {
            return (Boolean)response.getResponseValue();
        }

        @Override
        protected Boolean targetNotFound(Address sender) {
            return Boolean.TRUE;
        }
    }
}

