/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.infinispan.commons.GlobalContextInitializerImpl;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.persistence.impl.PersistenceContextInitializerImpl;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;

@Scope(value=Scopes.GLOBAL)
public class SerializationContextRegistryImpl
implements SerializationContextRegistry {
    @Inject
    GlobalConfiguration globalConfig;
    private final MarshallerContext global = new MarshallerContext();
    private final MarshallerContext persistence = new MarshallerContext();

    @Start
    public void start() {
        List<SerializationContextInitializer> scis = this.globalConfig.serialization().contextInitializers();
        this.update(SerializationContextRegistry.MarshallerType.GLOBAL, ctx -> {
            if (scis != null) {
                ctx.addContextIntializers(scis);
            }
            ctx.addContextIntializer(new PersistenceContextInitializerImpl()).addContextIntializer((SerializationContextInitializer)new GlobalContextInitializerImpl()).update();
        });
        this.update(SerializationContextRegistry.MarshallerType.PERSISTENCE, ctx -> {
            if (scis != null) {
                ctx.addContextIntializers(scis);
            }
            ctx.addContextIntializer(new PersistenceContextInitializerImpl()).update();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSerializationContext getGlobalCtx() {
        MarshallerContext marshallerContext = this.global;
        synchronized (marshallerContext) {
            return this.global.ctx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSerializationContext getPersistenceCtx() {
        MarshallerContext marshallerContext = this.persistence;
        synchronized (marshallerContext) {
            return this.persistence.ctx;
        }
    }

    @Override
    public void addContextInitializer(SerializationContextRegistry.MarshallerType type, SerializationContextInitializer sci) {
        this.update(type, ctx -> ctx.addContextIntializer(sci).update());
    }

    @Override
    public void addProtoFile(SerializationContextRegistry.MarshallerType type, FileDescriptorSource fileDescriptorSource) {
        this.update(type, ctx -> ctx.addProtoFile(fileDescriptorSource).update());
    }

    @Override
    public void addMarshaller(SerializationContextRegistry.MarshallerType type, BaseMarshaller marshaller) {
        this.update(type, ctx -> ctx.addMarshaller(marshaller).update());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(SerializationContextRegistry.MarshallerType type, Consumer<MarshallerContext> consumer) {
        if (type == SerializationContextRegistry.MarshallerType.GLOBAL) {
            MarshallerContext marshallerContext = this.global;
            synchronized (marshallerContext) {
                consumer.accept(this.global);
            }
        }
        MarshallerContext marshallerContext = this.persistence;
        synchronized (marshallerContext) {
            consumer.accept(this.persistence);
        }
    }

    static class MarshallerContext {
        private final List<SerializationContextInitializer> initializers = new ArrayList<SerializationContextInitializer>();
        private final List<FileDescriptorSource> schemas = new ArrayList<FileDescriptorSource>();
        private final List<BaseMarshaller<?>> marshallers = new ArrayList();
        private SerializationContext ctx = ProtobufUtil.newSerializationContext();

        MarshallerContext() {
        }

        MarshallerContext addContextIntializers(List<SerializationContextInitializer> scis) {
            this.initializers.addAll(scis);
            return this;
        }

        MarshallerContext addContextIntializer(SerializationContextInitializer sci) {
            this.initializers.add(sci);
            return this;
        }

        MarshallerContext addProtoFile(FileDescriptorSource fileDescriptorSource) {
            this.schemas.add(fileDescriptorSource);
            return this;
        }

        MarshallerContext addMarshaller(BaseMarshaller marshaller) {
            this.marshallers.add(marshaller);
            return this;
        }

        void update() {
            this.initializers.forEach(sci -> {
                sci.registerSchema(this.ctx);
                sci.registerMarshallers(this.ctx);
            });
            this.schemas.forEach(arg_0 -> ((SerializationContext)this.ctx).registerProtoFiles(arg_0));
            this.marshallers.forEach(arg_0 -> ((SerializationContext)this.ctx).registerMarshaller(arg_0));
        }
    }
}

