/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.Optional;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.Ownership;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.impl.AbstractIracLocalSiteInterceptor;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.util.IracUtils;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxIracLocalSiteInterceptor
extends AbstractIracLocalSiteInterceptor {
    private static final Log log = LogFactory.getLog(NonTxIracLocalSiteInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private final InvocationFinallyAction<WriteCommand> afterWriteCommand = this::handleWriteCommand;

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) {
        return this.visitWriteCommand(ctx, command);
    }

    @Override
    public boolean isTraceEnabled() {
        return trace;
    }

    @Override
    public Log getLog() {
        return log;
    }

    private Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        Object key = command.getKey();
        if (NonTxIracLocalSiteInterceptor.isIracState(command)) {
            this.setMetadataToCacheEntry(ctx.lookupEntry(key), command.getInternalMetadata(key).iracMetadata());
            return this.invokeNext(ctx, command);
        }
        if (this.skipCommand(ctx, command)) {
            return this.invokeNext(ctx, command);
        }
        this.visitKey(ctx, key, command);
        return this.invokeNextAndFinally(ctx, command, this::handleDataWriteCommand);
    }

    private Object visitWriteCommand(InvocationContext ctx, WriteCommand command) {
        if (this.skipCommand(ctx, command)) {
            return this.invokeNext(ctx, command);
        }
        for (Object key : command.getAffectedKeys()) {
            this.visitKey(ctx, key, command);
        }
        return this.invokeNextAndFinally(ctx, command, this.afterWriteCommand);
    }

    private boolean skipCommand(InvocationContext ctx, FlagAffectedCommand command) {
        return ctx.isInTxScope() || command.hasAnyFlag(FlagBitSets.IRAC_UPDATE);
    }

    private void visitKey(InvocationContext ctx, Object key, WriteCommand command) {
        IracMetadata metadata;
        int segment = this.getSegment(command, key);
        if (this.getOwnership(segment) != Ownership.PRIMARY) {
            return;
        }
        Optional<IracMetadata> entryMetadata = IracUtils.findIracMetadataFromCacheEntry(ctx.lookupEntry(key));
        if (command instanceof RemoveExpiredCommand) {
            metadata = entryMetadata.orElseGet(() -> this.iracVersionGenerator.generateMetadataWithCurrentVersion(segment));
        } else {
            IracEntryVersion versionSeen = entryMetadata.map(IracMetadata::getVersion).orElse(null);
            metadata = this.iracVersionGenerator.generateNewMetadata(segment, versionSeen);
        }
        NonTxIracLocalSiteInterceptor.updateCommandMetadata(key, command, metadata);
        if (trace) {
            log.tracef("[IRAC] New metadata for key '%s' is %s. Command=%s", key, metadata, command);
        }
    }

    private void handleDataWriteCommand(InvocationContext ctx, DataWriteCommand command, Object rv, Throwable t) {
        Object key = command.getKey();
        if (!command.isSuccessful() || this.skipEntryCommit(ctx, command, key)) {
            return;
        }
        this.setMetadataToCacheEntry(ctx.lookupEntry(key), command.getInternalMetadata(key).iracMetadata());
    }

    private void handleWriteCommand(InvocationContext ctx, WriteCommand command, Object rv, Throwable t) {
        if (!command.isSuccessful()) {
            return;
        }
        for (Object key : command.getAffectedKeys()) {
            if (this.skipEntryCommit(ctx, command, key)) continue;
            this.setMetadataToCacheEntry(ctx.lookupEntry(key), command.getInternalMetadata(key).iracMetadata());
        }
    }

    private boolean skipEntryCommit(InvocationContext ctx, WriteCommand command, Object key) {
        switch (this.getOwnership(this.getSegment(command, key))) {
            case NON_OWNER: {
                return true;
            }
            case BACKUP: {
                if (!ctx.isOriginLocal()) break;
                return true;
            }
        }
        return false;
    }
}

