/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.IndexMergeConfiguration;
import org.infinispan.configuration.parsing.Element;

public class IndexWriterConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Integer> INDEX_THREAD_POOL_SIZE = AttributeDefinition.builder((String)"thread-pool-size", (Object)1, Integer.class).immutable().build();
    public static final AttributeDefinition<Integer> INDEX_QUEUE_COUNT = AttributeDefinition.builder((String)"queue-count", (Object)1, Integer.class).immutable().build();
    public static final AttributeDefinition<Integer> INDEX_QUEUE_SIZE = AttributeDefinition.builder((String)"queue-size", null, Integer.class).immutable().build();
    public static final AttributeDefinition<Integer> INDEX_COMMIT_INTERVAL = AttributeDefinition.builder((String)"commit-interval", null, Integer.class).immutable().build();
    public static final AttributeDefinition<Integer> INDEX_RAM_BUFFER_SIZE = AttributeDefinition.builder((String)"ram-buffer-size", null, Integer.class).immutable().build();
    public static final AttributeDefinition<Integer> INDEX_MAX_BUFFERED_DOCS = AttributeDefinition.builder((String)"max-buffered-docs", null, Integer.class).immutable().build();
    public static final AttributeDefinition<Boolean> INDEX_LOW_LEVEL_TRACE = AttributeDefinition.builder((String)"low-level-trace", (Object)false, Boolean.class).immutable().build();
    private final List<ConfigurationInfo> subElements;
    static final ElementDefinition<IndexWriterConfiguration> ELEMENT_DEFINITION = new DefaultElementDefinition(Element.INDEX_WRITER.getLocalName());
    private final AttributeSet attributes;
    private final IndexMergeConfiguration indexMergeConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(IndexWriterConfiguration.class, new AttributeDefinition[]{INDEX_THREAD_POOL_SIZE, INDEX_QUEUE_COUNT, INDEX_QUEUE_SIZE, INDEX_COMMIT_INTERVAL, INDEX_RAM_BUFFER_SIZE, INDEX_MAX_BUFFERED_DOCS, INDEX_LOW_LEVEL_TRACE});
    }

    IndexWriterConfiguration(AttributeSet attributes, IndexMergeConfiguration indexMergeConfiguration) {
        this.attributes = attributes.checkProtection();
        this.indexMergeConfiguration = indexMergeConfiguration;
        this.subElements = Collections.singletonList(indexMergeConfiguration);
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public ElementDefinition<IndexWriterConfiguration> getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexMergeConfiguration merge() {
        return this.indexMergeConfiguration;
    }

    public Integer getThreadPoolSize() {
        return (Integer)this.attributes.attribute(INDEX_THREAD_POOL_SIZE).get();
    }

    public Integer getQueueCount() {
        return (Integer)this.attributes.attribute(INDEX_QUEUE_COUNT).get();
    }

    public Integer getQueueSize() {
        return (Integer)this.attributes.attribute(INDEX_QUEUE_SIZE).get();
    }

    public Integer getCommitInterval() {
        return (Integer)this.attributes.attribute(INDEX_COMMIT_INTERVAL).get();
    }

    public Integer getRamBufferSize() {
        return (Integer)this.attributes.attribute(INDEX_RAM_BUFFER_SIZE).get();
    }

    public Integer getMaxBufferedDocs() {
        return (Integer)this.attributes.attribute(INDEX_MAX_BUFFERED_DOCS).get();
    }

    public Boolean isLowLevelTrace() {
        return (Boolean)this.attributes.attribute(INDEX_LOW_LEVEL_TRACE).get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexWriterConfiguration that = (IndexWriterConfiguration)o;
        if (!this.attributes.equals((Object)that.attributes)) {
            return false;
        }
        return this.indexMergeConfiguration.equals(that.indexMergeConfiguration);
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + this.indexMergeConfiguration.hashCode();
        return result;
    }

    public String toString() {
        return "IndexWriterConfiguration{attributes=" + this.attributes + ", indexMergeConfiguration=" + this.indexMergeConfiguration + '}';
    }
}

