/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.remote.BaseClusteredReadCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusteredGetCommand
extends BaseClusteredReadCommand
implements SegmentSpecificCommand {
    public static final byte COMMAND_ID = 16;
    private static final Log log = LogFactory.getLog(ClusteredGetCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Object key;
    private boolean isWrite;
    private Integer segment;

    private ClusteredGetCommand() {
        super(null, 0L);
    }

    public ClusteredGetCommand(ByteString cacheName) {
        super(cacheName, 0L);
    }

    public ClusteredGetCommand(Object key, ByteString cacheName, Integer segment, long flags) {
        super(cacheName, flags);
        this.key = key;
        this.isWrite = false;
        if (segment != null && segment < 0) {
            throw new IllegalArgumentException("Segment must 0 or greater!");
        }
        this.segment = segment;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        TransactionConfiguration transactionConfiguration;
        long flagBitSet = EnumUtil.bitSetOf((Enum)Flag.SKIP_REMOTE_LOOKUP);
        int segmentToUse = this.segment != null ? this.segment.intValue() : componentRegistry.getComponent(KeyPartitioner.class).getSegment(this.key);
        if (this.isWrite && (transactionConfiguration = componentRegistry.getConfiguration().transaction()).transactionMode() == TransactionMode.TRANSACTIONAL && transactionConfiguration.lockingMode() == LockingMode.PESSIMISTIC) {
            flagBitSet = EnumUtil.mergeBitSets((long)flagBitSet, (long)FlagBitSets.ALREADY_HAS_LOCK);
        }
        GetCacheEntryCommand command = componentRegistry.getCommandsFactory().buildGetCacheEntryCommand(this.key, segmentToUse, EnumUtil.mergeBitSets((long)flagBitSet, (long)this.getFlagsBitSet()));
        command.setTopologyId(this.topologyId);
        InvocationContextFactory icf = componentRegistry.getInvocationContextFactory().running();
        InvocationContext invocationContext = icf.createRemoteInvocationContextForCommand(command, this.getOrigin());
        AsyncInterceptorChain invoker = componentRegistry.getInterceptorChain().running();
        return invoker.invokeAsync(invocationContext, command).thenApply(rv -> {
            if (trace) {
                log.tracef("Return value for key=%s is %s", this.key, rv);
            }
            if (rv instanceof MVCCEntry) {
                MVCCEntry mvccEntry = (MVCCEntry)rv;
                InternalCacheValue icv = componentRegistry.getInternalEntryFactory().wired().createValue(mvccEntry);
                icv.setInternalMetadata(mvccEntry.getInternalMetadata());
                return icv;
            }
            if (rv instanceof InternalCacheEntry) {
                InternalCacheEntry internalCacheEntry = (InternalCacheEntry)rv;
                return internalCacheEntry.toInternalCacheValue();
            }
            return rv;
        });
    }

    @Deprecated
    public GlobalTransaction getGlobalTransaction() {
        return null;
    }

    @Override
    public byte getCommandId() {
        return 16;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        if (this.segment != null) {
            output.writeBoolean(true);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
        } else {
            output.writeBoolean(false);
        }
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        output.writeBoolean(this.isWrite);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        boolean hasSegment = input.readBoolean();
        if (hasSegment) {
            this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        }
        this.setFlagsBitSet(input.readLong());
        this.isWrite = input.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusteredGetCommand that = (ClusteredGetCommand)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }

    @Override
    public String toString() {
        return "ClusteredGetCommand{key=" + this.key + ", flags=" + this.printFlags() + ", topologyId=" + this.topologyId + ", isWrite=" + this.isWrite + "}";
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public void setWrite(boolean write) {
        this.isWrite = write;
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }
}

