/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.protostream.descriptors.Type;

@ProtoTypeId(value=1007)
public class TopologyIracVersion
implements Comparable<TopologyIracVersion> {
    private final int topologyId;
    private final long version;

    @ProtoFactory
    public TopologyIracVersion(int topologyId, long version) {
        this.topologyId = topologyId;
        this.version = version;
    }

    public static TopologyIracVersion newVersion(int currentTopologyId) {
        return new TopologyIracVersion(currentTopologyId, 1L);
    }

    public static TopologyIracVersion max(TopologyIracVersion v1, TopologyIracVersion v2) {
        return v1.compareTo(v2) < 0 ? v2 : v1;
    }

    @ProtoField(number=1, type=Type.UINT32, defaultValue="0")
    public int getTopologyId() {
        return this.topologyId;
    }

    @ProtoField(number=2, type=Type.UINT64, defaultValue="0")
    public long getVersion() {
        return this.version;
    }

    public TopologyIracVersion increment(int currentTopologyId) {
        long newVersion = currentTopologyId == this.topologyId ? this.version + 1L : 1L;
        return new TopologyIracVersion(currentTopologyId, newVersion);
    }

    @Override
    public int compareTo(TopologyIracVersion other) {
        if (this.topologyId < other.topologyId) {
            return -1;
        }
        if (this.topologyId > other.topologyId) {
            return 1;
        }
        return Long.compare(this.version, other.version);
    }

    public String toString() {
        return '(' + Integer.toString(this.topologyId) + ':' + this.version + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyIracVersion that = (TopologyIracVersion)o;
        return this.topologyId == that.topologyId && this.version == that.version;
    }

    public int hashCode() {
        int result = this.topologyId;
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }
}

