/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.time.TimeService;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.util.logging.Log;

@MBean
@Scope(value=Scopes.NONE)
public abstract class AbstractClusterStats
implements JmxStatisticsExposer {
    public static final long DEFAULT_STALE_STATS_THRESHOLD = 3000L;
    @Inject
    TimeService timeService;
    private volatile long staleStatsThreshold = 3000L;
    private volatile long statsUpdateTimestamp = 0L;
    volatile boolean statisticsEnabled = false;
    private final Log log;
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    final HashMap<String, Number> statsMap = new HashMap();

    AbstractClusterStats(Log log) {
        this.log = log;
    }

    abstract void updateStats() throws Exception;

    @Start
    void start() {
        this.setStatisticsEnabled(this.statisticsEnabled);
    }

    public void reset() {
        this.statsMap.clear();
    }

    @ManagedAttribute(description="Gets the threshold for cluster wide stats refresh (milliseconds)", displayName="Stale Stats Threshold", dataType=DataType.TRAIT, writable=true)
    public long getStaleStatsThreshold() {
        return this.staleStatsThreshold;
    }

    public void setStaleStatsThreshold(long staleStatsThreshold) {
        this.staleStatsThreshold = staleStatsThreshold;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        if (this.isStatisticsEnabled()) {
            this.reset();
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @ManagedAttribute(description="Number of seconds since the cluster-wide statistics were last reset", displayName="Seconds since cluster-wide statistics were reset", units=Units.SECONDS)
    public long getTimeSinceReset() {
        long result = -1L;
        if (this.isStatisticsEnabled()) {
            result = this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
        }
        return result;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
        if (enabled) {
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.getStatisticsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void fetchClusterWideStatsIfNeeded() {
        long duration = this.timeService.timeDuration(this.statsUpdateTimestamp, this.timeService.time(), TimeUnit.MILLISECONDS);
        if (duration > this.staleStatsThreshold) {
            try {
                this.updateStats();
            }
            catch (Exception e) {
                this.log.error("Could not execute cluster wide cache stats operation ", e);
            }
            finally {
                this.statsUpdateTimestamp = this.timeService.time();
            }
        }
    }

    long addLongAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        long total = 0L;
        for (Map<String, Number> m : responseList) {
            Number value = m.get(attribute);
            long longValue = value.longValue();
            if (longValue >= 0L) {
                total += longValue;
                continue;
            }
            total = -1L;
        }
        return total;
    }

    private int addIntAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        int total = 0;
        for (Map<String, Number> m : responseList) {
            Number value = m.get(attribute);
            int intValue = value.intValue();
            if (intValue >= 0) {
                total += intValue;
                continue;
            }
            total = -1;
        }
        return total;
    }

    private int maxIntAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        int max = -1;
        for (Map<String, Number> m : responseList) {
            Number value = m.get(attribute);
            int intValue = value.intValue();
            max = Math.max(max, intValue);
        }
        return max;
    }

    void putLongAttributesAverage(Collection<Map<String, Number>> responseList, String attribute) {
        long numValues = 0L;
        long total = 0L;
        for (Map<String, Number> m : responseList) {
            Number value = m.get(attribute);
            long longValue = value.longValue();
            if (longValue < 0L) continue;
            total += longValue;
            ++numValues;
        }
        if (numValues > 0L) {
            long average = total / numValues;
            this.statsMap.put(attribute, average);
        }
    }

    void putLongAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        this.statsMap.put(attribute, this.addLongAttributes(responseList, attribute));
    }

    void putIntAttributes(Collection<Map<String, Number>> responseList, String attribute) {
        this.statsMap.put(attribute, this.addIntAttributes(responseList, attribute));
    }

    void putIntAttributesMax(Collection<Map<String, Number>> responseList, String attribute) {
        this.statsMap.put(attribute, this.maxIntAttributes(responseList, attribute));
    }

    long getStatAsLong(String attribute) {
        return this.getStat(attribute).longValue();
    }

    int getStatAsInt(String attribute) {
        return this.getStat(attribute).intValue();
    }

    private Number getStat(String attribute) {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.statsMap.getOrDefault(attribute, 0);
        }
        return -1;
    }
}

