/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.remoting.inboundhandler.action.Action;
import org.infinispan.remoting.inboundhandler.action.ActionListener;
import org.infinispan.remoting.inboundhandler.action.ActionState;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;

public class DefaultReadyAction
implements ReadyAction,
ActionListener {
    private final ActionState state;
    private final Action[] actions;
    private final AtomicInteger currentAction;
    private final CompletableFuture<Void> notifier;

    public DefaultReadyAction(ActionState state, Action ... actions) {
        this.state = Objects.requireNonNull(state, "Action state must be non null.");
        this.actions = Objects.requireNonNull(actions, "Actions must be non null.");
        this.notifier = new CompletableFuture();
        this.currentAction = new AtomicInteger(0);
    }

    public void registerListener() {
        for (Action action : this.actions) {
            action.addListener(this);
        }
    }

    @Override
    public boolean isReady() {
        int current = this.currentAction.get();
        if (current >= this.actions.length) {
            return true;
        }
        Action action = this.actions[current];
        switch (action.check(this.state)) {
            case READY: {
                return this.currentAction.compareAndSet(current, current + 1) && this.isReady();
            }
            case NOT_READY: {
                return false;
            }
            case CANCELED: {
                this.currentAction.set(this.actions.length);
                return true;
            }
        }
        return false;
    }

    @Override
    public void addListener(ActionListener listener) {
        if (this.notifier.isDone()) {
            listener.onComplete();
        } else {
            this.notifier.thenRun(listener::onComplete);
        }
    }

    @Override
    public void onException() {
        InfinispanCollections.forEach((Object[])this.actions, action -> action.onException(this.state));
    }

    @Override
    public void onComplete() {
        if (this.isReady()) {
            this.notifier.complete(null);
        }
    }

    @Override
    public void onFinally() {
        InfinispanCollections.forEach((Object[])this.actions, action -> action.onFinally(this.state));
    }
}

