/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.util.logging.Log;

public class L1ConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<L1Configuration> {
    private final AttributeSet attributes = L1Configuration.attributeDefinitionSet();

    L1ConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public L1ConfigurationBuilder invalidationThreshold(int invalidationThreshold) {
        this.attributes.attribute(L1Configuration.INVALIDATION_THRESHOLD).set((Object)invalidationThreshold);
        return this;
    }

    public L1ConfigurationBuilder lifespan(long lifespan) {
        this.attributes.attribute(L1Configuration.LIFESPAN).set((Object)lifespan);
        return this;
    }

    public L1ConfigurationBuilder lifespan(long lifespan, TimeUnit unit) {
        return this.lifespan(unit.toMillis(lifespan));
    }

    public L1ConfigurationBuilder cleanupTaskFrequency(long frequencyMillis) {
        this.attributes.attribute(L1Configuration.CLEANUP_TASK_FREQUENCY).set((Object)frequencyMillis);
        return this;
    }

    public L1ConfigurationBuilder cleanupTaskFrequency(long frequencyMillis, TimeUnit unit) {
        return this.cleanupTaskFrequency(unit.toMillis(frequencyMillis));
    }

    public L1ConfigurationBuilder enable() {
        this.attributes.attribute(L1Configuration.ENABLED).set((Object)true);
        return this;
    }

    public L1ConfigurationBuilder disable() {
        this.attributes.attribute(L1Configuration.ENABLED).set((Object)false);
        return this;
    }

    public L1ConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(L1Configuration.ENABLED).set((Object)enabled);
        return this;
    }

    public void validate() {
        if (((Boolean)this.attributes.attribute(L1Configuration.ENABLED).get()).booleanValue()) {
            if (!this.clustering().cacheMode().isDistributed()) {
                throw Log.CONFIG.l1OnlyForDistributedCache(this.clustering().cacheMode().friendlyCacheModeString());
            }
            if ((Long)this.attributes.attribute(L1Configuration.LIFESPAN).get() < 1L) {
                throw Log.CONFIG.l1InvalidLifespan();
            }
            MemoryConfigurationBuilder memoryConfigurationBuilder = this.getClusteringBuilder().memory();
            if (memoryConfigurationBuilder.evictionStrategy() == EvictionStrategy.EXCEPTION) {
                throw Log.CONFIG.l1NotValidWithExpirationEviction();
            }
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public L1Configuration create() {
        return new L1Configuration(this.attributes.protect());
    }

    public L1ConfigurationBuilder read(L1Configuration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "L1ConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

