/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.counter.impl.function.BaseCreateFunction;
import org.infinispan.counter.impl.function.FunctionHelper;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;

public class CreateAndCASFunction<K extends CounterKey>
extends BaseCreateFunction<K, Object> {
    public static final AdvancedExternalizer<CreateAndCASFunction> EXTERNALIZER = new Externalizer();
    private final long expect;
    private final long value;

    public CreateAndCASFunction(CounterConfiguration configuration, long expect, long value) {
        super(configuration);
        this.expect = expect;
        this.value = value;
    }

    @Override
    Object apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView, CounterValue currentValue, CounterConfigurationMetaParam metadata) {
        return FunctionHelper.compareAndSwap(entryView, currentValue, metadata, this.expect, this.value);
    }

    private static class Externalizer
    implements AdvancedExternalizer<CreateAndCASFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends CreateAndCASFunction>> getTypeClasses() {
            return Collections.singleton(CreateAndCASFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.CREATE_CAS_FUNCTION;
        }

        public void writeObject(ObjectOutput output, CreateAndCASFunction object) throws IOException {
            output.writeObject(object.configuration);
            output.writeLong(object.expect);
            output.writeLong(object.value);
        }

        public CreateAndCASFunction<?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CreateAndCASFunction((CounterConfiguration)input.readObject(), input.readLong(), input.readLong());
        }
    }
}

