/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.jdk;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestSchemaClient;
import org.infinispan.client.rest.impl.jdk.RestClientJDK;
import org.infinispan.client.rest.impl.jdk.RestRawClientJDK;
import org.infinispan.commons.dataconversion.MediaType;

public class RestSchemaClientJDK
implements RestSchemaClient {
    private final RestRawClientJDK client;
    private final String path;

    public RestSchemaClientJDK(RestRawClientJDK client) {
        this.client = client;
        this.path = client.getConfiguration().contextPath() + "/v2/schemas";
    }

    @Override
    public CompletionStage<RestResponse> names() {
        return this.client.get(this.path);
    }

    @Override
    public CompletionStage<RestResponse> types() {
        return this.client.get(this.path + "?action=types");
    }

    @Override
    public CompletionStage<RestResponse> post(String schemaName, String schemaContents) {
        return this.client.post(this.schemaUrl(schemaName), RestEntity.create(MediaType.TEXT_PLAIN, schemaContents));
    }

    @Override
    public CompletionStage<RestResponse> post(String schemaName, RestEntity schemaContents) {
        return this.client.post(this.schemaUrl(schemaName), schemaContents);
    }

    @Override
    public CompletionStage<RestResponse> put(String schemaName, String schemaContents) {
        return this.client.put(this.schemaUrl(schemaName), RestEntity.create(MediaType.TEXT_PLAIN, schemaContents));
    }

    @Override
    public CompletionStage<RestResponse> put(String schemaName, RestEntity schemaContents) {
        return this.client.put(this.schemaUrl(schemaName), schemaContents);
    }

    @Override
    public CompletionStage<RestResponse> delete(String schemaName) {
        return this.client.delete(this.schemaUrl(schemaName));
    }

    @Override
    public CompletionStage<RestResponse> get(String schemaName) {
        return this.client.get(this.schemaUrl(schemaName), Map.of("Accept", "text/plain"));
    }

    private String schemaUrl(String name) {
        return this.path + "/" + RestClientJDK.sanitize(name);
    }
}

