/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.encode;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$MoreObjects;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$Lists;
import org.immutables.value.internal.$guava$.primitives.$Booleans;

@ParametersAreNonnullByDefault
final class $ImmutableStructurizer {
    private $ImmutableStructurizer() {
    }

    @Immutable
    static final class Statement
    extends .processor..Structurizer.Statement {
        private final $ImmutableList<.processor..Code.Term> annotations;
        private final $ImmutableList<.processor..Code.Term> signature;
        private final $ImmutableList<.processor..Code.Term> parameters;
        private final $ImmutableList<.processor..Code.Term> expression;
        private final $ImmutableList<.processor..Code.Term> block;
        private final $ImmutableList<.processor..Structurizer.Statement> definitions;
        private final boolean isClass;
        private final $Optional<String> name;
        private static final int STAGE_INITIALIZING = -1;
        private static final int STAGE_UNINITIALIZED = 0;
        private static final int STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Statement(Builder builder) {
            this.annotations = builder.annotations.build();
            this.signature = builder.signature.build();
            this.parameters = builder.parameters.build();
            this.expression = builder.expression.build();
            this.block = builder.block.build();
            this.definitions = builder.definitions.build();
            if (builder.nameIsSet()) {
                this.initShim.name(builder.name);
            }
            this.name = this.initShim.name();
            this.isClass = this.initShim.isClass();
            this.initShim = null;
        }

        private Statement($ImmutableList<.processor..Code.Term> annotations, $ImmutableList<.processor..Code.Term> signature, $ImmutableList<.processor..Code.Term> parameters, $ImmutableList<.processor..Code.Term> expression, $ImmutableList<.processor..Code.Term> block, $ImmutableList<.processor..Structurizer.Statement> definitions, $Optional<String> name) {
            this.annotations = annotations;
            this.signature = signature;
            this.parameters = parameters;
            this.expression = expression;
            this.block = block;
            this.definitions = definitions;
            this.name = name;
            this.initShim.name(this.name);
            this.isClass = this.initShim.isClass();
            this.initShim = null;
        }

        $ImmutableList<.processor..Code.Term> annotations() {
            return this.annotations;
        }

        $ImmutableList<.processor..Code.Term> signature() {
            return this.signature;
        }

        $ImmutableList<.processor..Code.Term> parameters() {
            return this.parameters;
        }

        $ImmutableList<.processor..Code.Term> expression() {
            return this.expression;
        }

        $ImmutableList<.processor..Code.Term> block() {
            return this.block;
        }

        $ImmutableList<.processor..Structurizer.Statement> definitions() {
            return this.definitions;
        }

        @Override
        boolean isClass() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isClass() : this.isClass;
        }

        @Override
        $Optional<String> name() {
            InitShim shim = this.initShim;
            return shim != null ? shim.name() : this.name;
        }

        public final Statement withAnnotations(.processor..Code.Term ... elements) {
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(newValue, this.signature, this.parameters, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withAnnotations(Iterable<? extends .processor..Code.Term> elements) {
            if (this.annotations == elements) {
                return this;
            }
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(newValue, this.signature, this.parameters, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withSignature(.processor..Code.Term ... elements) {
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, newValue, this.parameters, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withSignature(Iterable<? extends .processor..Code.Term> elements) {
            if (this.signature == elements) {
                return this;
            }
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, newValue, this.parameters, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withParameters(.processor..Code.Term ... elements) {
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, newValue, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withParameters(Iterable<? extends .processor..Code.Term> elements) {
            if (this.parameters == elements) {
                return this;
            }
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, newValue, this.expression, this.block, this.definitions, this.name);
        }

        public final Statement withExpression(.processor..Code.Term ... elements) {
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, this.parameters, newValue, this.block, this.definitions, this.name);
        }

        public final Statement withExpression(Iterable<? extends .processor..Code.Term> elements) {
            if (this.expression == elements) {
                return this;
            }
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, this.parameters, newValue, this.block, this.definitions, this.name);
        }

        public final Statement withBlock(.processor..Code.Term ... elements) {
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, newValue, this.definitions, this.name);
        }

        public final Statement withBlock(Iterable<? extends .processor..Code.Term> elements) {
            if (this.block == elements) {
                return this;
            }
            $ImmutableList<.processor..Code.Term> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, newValue, this.definitions, this.name);
        }

        public final Statement withDefinitions(.processor..Structurizer.Statement ... elements) {
            $ImmutableList<.processor..Structurizer.Statement> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, this.block, newValue, this.name);
        }

        public final Statement withDefinitions(Iterable<? extends .processor..Structurizer.Statement> elements) {
            if (this.definitions == elements) {
                return this;
            }
            $ImmutableList<.processor..Structurizer.Statement> newValue = $ImmutableList.copyOf(elements);
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, this.block, newValue, this.name);
        }

        public final Statement withName($Optional<String> name) {
            if (this.name == name) {
                return this;
            }
            $Optional<String> newValue = $Preconditions.checkNotNull(name, "name");
            return new Statement(this.annotations, this.signature, this.parameters, this.expression, this.block, this.definitions, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Statement && this.equalTo((Statement)another);
        }

        private boolean equalTo(Statement another) {
            return this.annotations.equals(another.annotations) && this.signature.equals(another.signature) && this.parameters.equals(another.parameters) && this.expression.equals(another.expression) && this.block.equals(another.block) && this.definitions.equals(another.definitions) && this.isClass == another.isClass && this.name.equals(another.name);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.annotations.hashCode();
            h = h * 17 + this.signature.hashCode();
            h = h * 17 + this.parameters.hashCode();
            h = h * 17 + this.expression.hashCode();
            h = h * 17 + this.block.hashCode();
            h = h * 17 + this.definitions.hashCode();
            h = h * 17 + $Booleans.hashCode(this.isClass);
            h = h * 17 + this.name.hashCode();
            return h;
        }

        public String toString() {
            return $MoreObjects.toStringHelper("Statement").omitNullValues().add("annotations", this.annotations).add("signature", this.signature).add("parameters", this.parameters).add("expression", this.expression).add("block", this.block).add("definitions", this.definitions).add("isClass", this.isClass).add("name", this.name).toString();
        }

        public static .processor..Structurizer.Statement copyOf(.processor..Structurizer.Statement instance) {
            if (instance instanceof Statement) {
                return (Statement)instance;
            }
            return new .processor..Structurizer.Statement.Builder().addAllAnnotations(instance.annotations()).addAllSignature(instance.signature()).addAllParameters(instance.parameters()).addAllExpression(instance.expression()).addAllBlock(instance.block()).addAllDefinitions(instance.definitions()).name(instance.name()).build();
        }

        @NotThreadSafe
        static class Builder {
            private static final long OPT_BIT_NAME = 1L;
            private long optBits;
            private $ImmutableList.Builder<.processor..Code.Term> annotations = $ImmutableList.builder();
            private $ImmutableList.Builder<.processor..Code.Term> signature = $ImmutableList.builder();
            private $ImmutableList.Builder<.processor..Code.Term> parameters = $ImmutableList.builder();
            private $ImmutableList.Builder<.processor..Code.Term> expression = $ImmutableList.builder();
            private $ImmutableList.Builder<.processor..Code.Term> block = $ImmutableList.builder();
            private $ImmutableList.Builder<.processor..Structurizer.Statement> definitions = $ImmutableList.builder();
            @Nullable
            private $Optional<String> name;

            Builder() {
                if (!(this instanceof .processor..Structurizer.Statement.Builder)) {
                    throw new UnsupportedOperationException("Use: new Structurizer.Statement.Builder()");
                }
            }

            public final .processor..Structurizer.Statement.Builder addAnnotations(.processor..Code.Term element) {
                this.annotations.add((Object)element);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addAnnotations(.processor..Code.Term ... elements) {
                this.annotations.add(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addAllAnnotations(Iterable<? extends .processor..Code.Term> elements) {
                this.annotations.addAll(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addSignature(.processor..Code.Term element) {
                this.signature.add((Object)element);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addSignature(.processor..Code.Term ... elements) {
                this.signature.add(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addAllSignature(Iterable<? extends .processor..Code.Term> elements) {
                this.signature.addAll(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addParameters(.processor..Code.Term element) {
                this.parameters.add((Object)element);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addParameters(.processor..Code.Term ... elements) {
                this.parameters.add(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addAllParameters(Iterable<? extends .processor..Code.Term> elements) {
                this.parameters.addAll(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addExpression(.processor..Code.Term element) {
                this.expression.add((Object)element);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addExpression(.processor..Code.Term ... elements) {
                this.expression.add(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addAllExpression(Iterable<? extends .processor..Code.Term> elements) {
                this.expression.addAll(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addBlock(.processor..Code.Term element) {
                this.block.add((Object)element);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addBlock(.processor..Code.Term ... elements) {
                this.block.add(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addAllBlock(Iterable<? extends .processor..Code.Term> elements) {
                this.block.addAll(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addDefinitions(.processor..Structurizer.Statement element) {
                this.definitions.add((Object)element);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addDefinitions(.processor..Structurizer.Statement ... elements) {
                this.definitions.add(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder addAllDefinitions(Iterable<? extends .processor..Structurizer.Statement> elements) {
                this.definitions.addAll(elements);
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public final .processor..Structurizer.Statement.Builder name($Optional<String> name) {
                this.checkNotIsSet(this.nameIsSet(), "name");
                this.name = $Preconditions.checkNotNull(name, "name");
                this.optBits |= 1L;
                return (.processor..Structurizer.Statement.Builder)this;
            }

            public .processor..Structurizer.Statement build() {
                return new Statement(this);
            }

            private boolean nameIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private void checkNotIsSet(boolean isSet, String name) {
                if (isSet) {
                    throw new IllegalStateException("Builder of Statement is strict, attribute is already set: ".concat(name));
                }
            }
        }

        private final class InitShim {
            private boolean isClass;
            private int isClassStage;
            private $Optional<String> name;
            private int nameStage;

            private InitShim() {
            }

            boolean isClass() {
                if (this.isClassStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.isClassStage == 0) {
                    this.isClassStage = -1;
                    this.isClass = Statement.super.isClass();
                    this.isClassStage = 1;
                }
                return this.isClass;
            }

            $Optional<String> name() {
                if (this.nameStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.nameStage == 0) {
                    this.nameStage = -1;
                    this.name = $Preconditions.checkNotNull(Statement.super.name(), "name");
                    this.nameStage = 1;
                }
                return this.name;
            }

            void name($Optional<String> name) {
                this.name = name;
                this.nameStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = $Lists.newArrayList();
                if (this.isClassStage == -1) {
                    attributes.add("isClass");
                }
                if (this.nameStage == -1) {
                    attributes.add("name");
                }
                return "Cannot build Statement, attribute initializers form cycle" + attributes;
            }
        }
    }
}

