/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.htmlunit.cyberneko.xerces.xni.NamespaceContext;

public class NamespaceSupport
implements NamespaceContext {
    private String[] fNamespace = new String[32];
    private int fNamespaceSize;
    private int[] fContext = new int[8];
    private int fCurrentContext;
    private String[] fPrefixes = new String[16];

    @Override
    public void reset() {
        this.fNamespaceSize = 0;
        this.fCurrentContext = 0;
        this.fContext[this.fCurrentContext] = this.fNamespaceSize;
        ++this.fCurrentContext;
    }

    @Override
    public void pushContext() {
        if (this.fCurrentContext + 1 == this.fContext.length) {
            int[] contextarray = new int[this.fContext.length * 2];
            System.arraycopy(this.fContext, 0, contextarray, 0, this.fContext.length);
            this.fContext = contextarray;
        }
        this.fContext[++this.fCurrentContext] = this.fNamespaceSize;
    }

    @Override
    public void popContext() {
        this.fNamespaceSize = this.fContext[this.fCurrentContext--];
    }

    @Override
    public boolean declarePrefix(String prefix, String uri) {
        for (int i = this.fNamespaceSize; i > this.fContext[this.fCurrentContext]; i -= 2) {
            if (!Objects.equals(prefix, this.fNamespace[i - 2])) continue;
            this.fNamespace[i - 1] = uri;
            return true;
        }
        if (this.fNamespaceSize == this.fNamespace.length) {
            String[] namespacearray = new String[this.fNamespaceSize * 2];
            System.arraycopy(this.fNamespace, 0, namespacearray, 0, this.fNamespaceSize);
            this.fNamespace = namespacearray;
        }
        this.fNamespace[this.fNamespaceSize++] = prefix;
        this.fNamespace[this.fNamespaceSize++] = uri;
        return true;
    }

    @Override
    public String getURI(String prefix) {
        for (int i = this.fNamespaceSize; i > 0; i -= 2) {
            if (!Objects.equals(prefix, this.fNamespace[i - 2])) continue;
            return this.fNamespace[i - 1];
        }
        return null;
    }

    @Override
    public int getDeclaredPrefixCount() {
        return (this.fNamespaceSize - this.fContext[this.fCurrentContext]) / 2;
    }

    @Override
    public String getDeclaredPrefixAt(int index) {
        return this.fNamespace[this.fContext[this.fCurrentContext] + index * 2];
    }

    public boolean containsPrefix(String prefix) {
        for (int i = this.fNamespaceSize; i > 0; i -= 2) {
            if (!Objects.equals(prefix, this.fNamespace[i - 2])) continue;
            return true;
        }
        return false;
    }

    protected final class Prefixes
    implements Iterator<String> {
        private final String[] prefixes;
        private int counter = 0;
        private final int size;

        public Prefixes(String[] prefixes, int size) {
            this.prefixes = prefixes;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.counter < this.size;
        }

        @Override
        public String next() {
            if (this.counter < this.size) {
                return NamespaceSupport.this.fPrefixes[this.counter++];
            }
            throw new NoSuchElementException("Illegal access to Namespace prefixes enumeration.");
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                buf.append(this.prefixes[i]);
                buf.append(' ');
            }
            return buf.toString();
        }
    }
}

