/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.weld.transformer;

import org.hotswap.agent.annotation.OnClassLoadEvent;
import org.hotswap.agent.javassist.CannotCompileException;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.cdi.HaCdiCommons;
import org.hotswap.agent.plugin.weld.beans.ContextualReloadHelper;
import org.hotswap.agent.plugin.weld.beans.WeldHotswapContext;

public class CdiContextsTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(CdiContextsTransformer.class);
    public static final String BOUND_SESSION_BEAN_STORE_REGISTRY = "$$ha$boundSessionBeanStoreRegistry";

    @OnClassLoadEvent(classNameRegexp="(org.jboss.weld.context.AbstractManagedContext)|(org.jboss.weld.context.AbstractSharedContext)|(org.jboss.weld.context.unbound.DependentContextImpl)|(org.jboss.weld.util.ForwardingContext)|(org.apache.myfaces.flow.cdi.FlowScopedContextImpl)|(org.apache.myfaces.cdi.view.ViewScopeContextImpl)")
    public static void transformReloadingWeldContexts(CtClass ctClass, ClassPool classPool) throws NotFoundException, CannotCompileException {
        LOGGER.debug("Adding interface {} to {}.", new Object[]{WeldHotswapContext.class.getName(), ctClass.getName()});
        ctClass.addInterface(classPool.get(WeldHotswapContext.class.getName()));
        CtField toReloadFld = CtField.make((String)"public transient java.util.Set $$ha$toReloadWeld = null;", (CtClass)ctClass);
        ctClass.addField(toReloadFld);
        CtField reloadingFld = CtField.make((String)"public transient boolean $$ha$reloadingWeld = false;", (CtClass)ctClass);
        ctClass.addField(reloadingFld);
        CtMethod addBeanToReload = CtMethod.make((String)"public void $$ha$addBeanToReloadWeld(javax.enterprise.context.spi.Contextual bean) {if ($$ha$toReloadWeld == null)$$ha$toReloadWeld = new java.util.HashSet();$$ha$toReloadWeld.add(bean);}", (CtClass)ctClass);
        ctClass.addMethod(addBeanToReload);
        CtMethod getBeansToReload = CtMethod.make((String)"public java.util.Set $$ha$getBeansToReloadWeld(){return $$ha$toReloadWeld;}", (CtClass)ctClass);
        ctClass.addMethod(getBeansToReload);
        CtMethod reload = CtMethod.make((String)("public void $$ha$reloadWeld() {" + ContextualReloadHelper.class.getName() + ".reload(this);}"), (CtClass)ctClass);
        ctClass.addMethod(reload);
        CtMethod isActive = ctClass.getDeclaredMethod("isActive");
        isActive.insertAfter("{if($_ && !$$ha$reloadingWeld ) { $$ha$reloadingWeld = true;$$ha$reloadWeld();$$ha$reloadingWeld = false;}return $_;}");
        LOGGER.debug("Class '{}' patched with hot-swapping support", new Object[]{ctClass.getName()});
    }

    @OnClassLoadEvent(classNameRegexp="org.jboss.weld.context.AbstractContext")
    public static void transformHttpSessionContext(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        HaCdiCommons.transformContext((ClassPool)classPool, (CtClass)ctClass);
    }
}

