/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.stat.inference;

import java.util.Collection;
import org.hipparchus.distribution.RealDistribution;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.stat.descriptive.StatisticalSummary;
import org.hipparchus.stat.inference.ChiSquareTest;
import org.hipparchus.stat.inference.GTest;
import org.hipparchus.stat.inference.KolmogorovSmirnovTest;
import org.hipparchus.stat.inference.OneWayAnova;
import org.hipparchus.stat.inference.TTest;

public class InferenceTestUtils {
    private static final TTest T_TEST = new TTest();
    private static final ChiSquareTest CHI_SQUARE_TEST = new ChiSquareTest();
    private static final OneWayAnova ONE_WAY_ANANOVA = new OneWayAnova();
    private static final GTest G_TEST = new GTest();
    private static final KolmogorovSmirnovTest KS_TEST = new KolmogorovSmirnovTest();

    private InferenceTestUtils() {
    }

    public static double homoscedasticT(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException {
        return T_TEST.homoscedasticT(sample1, sample2);
    }

    public static double homoscedasticT(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws MathIllegalArgumentException, NullArgumentException {
        return T_TEST.homoscedasticT(sampleStats1, sampleStats2);
    }

    public static boolean homoscedasticTTest(double[] sample1, double[] sample2, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.homoscedasticTTest(sample1, sample2, alpha);
    }

    public static double homoscedasticTTest(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.homoscedasticTTest(sample1, sample2);
    }

    public static double homoscedasticTTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.homoscedasticTTest(sampleStats1, sampleStats2);
    }

    public static double pairedT(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException {
        return T_TEST.pairedT(sample1, sample2);
    }

    public static boolean pairedTTest(double[] sample1, double[] sample2, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.pairedTTest(sample1, sample2, alpha);
    }

    public static double pairedTTest(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.pairedTTest(sample1, sample2);
    }

    public static double t(double mu, double[] observed) throws MathIllegalArgumentException, NullArgumentException {
        return T_TEST.t(mu, observed);
    }

    public static double t(double mu, StatisticalSummary sampleStats) throws MathIllegalArgumentException, NullArgumentException {
        return T_TEST.t(mu, sampleStats);
    }

    public static double t(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException {
        return T_TEST.t(sample1, sample2);
    }

    public static double t(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws MathIllegalArgumentException, NullArgumentException {
        return T_TEST.t(sampleStats1, sampleStats2);
    }

    public static boolean tTest(double mu, double[] sample, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.tTest(mu, sample, alpha);
    }

    public static double tTest(double mu, double[] sample) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.tTest(mu, sample);
    }

    public static boolean tTest(double mu, StatisticalSummary sampleStats, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.tTest(mu, sampleStats, alpha);
    }

    public static double tTest(double mu, StatisticalSummary sampleStats) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.tTest(mu, sampleStats);
    }

    public static boolean tTest(double[] sample1, double[] sample2, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.tTest(sample1, sample2, alpha);
    }

    public static double tTest(double[] sample1, double[] sample2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.tTest(sample1, sample2);
    }

    public static boolean tTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.tTest(sampleStats1, sampleStats2, alpha);
    }

    public static double tTest(StatisticalSummary sampleStats1, StatisticalSummary sampleStats2) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return T_TEST.tTest(sampleStats1, sampleStats2);
    }

    public static double chiSquare(double[] expected, long[] observed) throws MathIllegalArgumentException {
        return CHI_SQUARE_TEST.chiSquare(expected, observed);
    }

    public static double chiSquare(long[][] counts) throws MathIllegalArgumentException, NullArgumentException {
        return CHI_SQUARE_TEST.chiSquare(counts);
    }

    public static boolean chiSquareTest(double[] expected, long[] observed, double alpha) throws MathIllegalArgumentException, MathIllegalStateException {
        return CHI_SQUARE_TEST.chiSquareTest(expected, observed, alpha);
    }

    public static double chiSquareTest(double[] expected, long[] observed) throws MathIllegalArgumentException, MathIllegalStateException {
        return CHI_SQUARE_TEST.chiSquareTest(expected, observed);
    }

    public static boolean chiSquareTest(long[][] counts, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return CHI_SQUARE_TEST.chiSquareTest(counts, alpha);
    }

    public static double chiSquareTest(long[][] counts) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return CHI_SQUARE_TEST.chiSquareTest(counts);
    }

    public static double chiSquareDataSetsComparison(long[] observed1, long[] observed2) throws MathIllegalArgumentException {
        return CHI_SQUARE_TEST.chiSquareDataSetsComparison(observed1, observed2);
    }

    public static double chiSquareTestDataSetsComparison(long[] observed1, long[] observed2) throws MathIllegalArgumentException, MathIllegalStateException {
        return CHI_SQUARE_TEST.chiSquareTestDataSetsComparison(observed1, observed2);
    }

    public static boolean chiSquareTestDataSetsComparison(long[] observed1, long[] observed2, double alpha) throws MathIllegalArgumentException, MathIllegalStateException {
        return CHI_SQUARE_TEST.chiSquareTestDataSetsComparison(observed1, observed2, alpha);
    }

    public static double oneWayAnovaFValue(Collection<double[]> categoryData) throws MathIllegalArgumentException, NullArgumentException {
        return ONE_WAY_ANANOVA.anovaFValue(categoryData);
    }

    public static double oneWayAnovaPValue(Collection<double[]> categoryData) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return ONE_WAY_ANANOVA.anovaPValue(categoryData);
    }

    public static boolean oneWayAnovaTest(Collection<double[]> categoryData, double alpha) throws MathIllegalArgumentException, NullArgumentException, MathIllegalStateException {
        return ONE_WAY_ANANOVA.anovaTest(categoryData, alpha);
    }

    public static double g(double[] expected, long[] observed) throws MathIllegalArgumentException {
        return G_TEST.g(expected, observed);
    }

    public static double gTest(double[] expected, long[] observed) throws MathIllegalArgumentException, MathIllegalStateException {
        return G_TEST.gTest(expected, observed);
    }

    public static double gTestIntrinsic(double[] expected, long[] observed) throws MathIllegalArgumentException, MathIllegalStateException {
        return G_TEST.gTestIntrinsic(expected, observed);
    }

    public static boolean gTest(double[] expected, long[] observed, double alpha) throws MathIllegalArgumentException, MathIllegalStateException {
        return G_TEST.gTest(expected, observed, alpha);
    }

    public static double gDataSetsComparison(long[] observed1, long[] observed2) throws MathIllegalArgumentException {
        return G_TEST.gDataSetsComparison(observed1, observed2);
    }

    public static double rootLogLikelihoodRatio(long k11, long k12, long k21, long k22) throws MathIllegalArgumentException {
        return G_TEST.rootLogLikelihoodRatio(k11, k12, k21, k22);
    }

    public static double gTestDataSetsComparison(long[] observed1, long[] observed2) throws MathIllegalArgumentException, MathIllegalStateException {
        return G_TEST.gTestDataSetsComparison(observed1, observed2);
    }

    public static boolean gTestDataSetsComparison(long[] observed1, long[] observed2, double alpha) throws MathIllegalArgumentException, MathIllegalStateException {
        return G_TEST.gTestDataSetsComparison(observed1, observed2, alpha);
    }

    public static double kolmogorovSmirnovStatistic(RealDistribution dist, double[] data) throws MathIllegalArgumentException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovStatistic(dist, data);
    }

    public static double kolmogorovSmirnovTest(RealDistribution dist, double[] data) throws MathIllegalArgumentException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(dist, data);
    }

    public static double kolmogorovSmirnovTest(RealDistribution dist, double[] data, boolean strict) throws MathIllegalArgumentException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(dist, data, strict);
    }

    public static boolean kolmogorovSmirnovTest(RealDistribution dist, double[] data, double alpha) throws MathIllegalArgumentException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(dist, data, alpha);
    }

    public static double kolmogorovSmirnovStatistic(double[] x, double[] y) throws MathIllegalArgumentException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovStatistic(x, y);
    }

    public static double kolmogorovSmirnovTest(double[] x, double[] y) throws MathIllegalArgumentException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(x, y);
    }

    public static double kolmogorovSmirnovTest(double[] x, double[] y, boolean strict) throws MathIllegalArgumentException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(x, y, strict);
    }

    public static double exactP(double d, int m, int n, boolean strict) {
        return KS_TEST.exactP(d, n, m, strict);
    }

    public static double approximateP(double d, int n, int m) {
        return KS_TEST.approximateP(d, n, m);
    }
}

