/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import java.util.ArrayList;
import java.util.Collections;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.EigenDecompositionSymmetric;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.scalar.ObjectiveFunction;
import org.hipparchus.optim.nonlinear.vector.constrained.ADMMQPOptimizer;
import org.hipparchus.optim.nonlinear.vector.constrained.AbstractSQPOptimizer;
import org.hipparchus.optim.nonlinear.vector.constrained.LagrangeSolution;
import org.hipparchus.optim.nonlinear.vector.constrained.LinearBoundedConstraint;
import org.hipparchus.optim.nonlinear.vector.constrained.LinearEqualityConstraint;
import org.hipparchus.optim.nonlinear.vector.constrained.LinearInequalityConstraint;
import org.hipparchus.optim.nonlinear.vector.constrained.QuadraticFunction;
import org.hipparchus.util.FastMath;

public class SQPOptimizerS
extends AbstractSQPOptimizer {
    private static final int FORGETTING_FACTOR = 10;
    private RealMatrix constraintJacob;
    private RealVector equalityEval;
    private RealVector inequalityEval;
    private RealVector functionGradient;
    private RealMatrix hessian;

    @Override
    public LagrangeSolution doOptimize() {
        int me = 0;
        int mi = 0;
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
        }
        if (this.getIqConstraint() != null) {
            mi = this.getIqConstraint().dimY();
        }
        double rho = 100.0;
        int failedSearch = 0;
        ArrayRealVector x = this.getStartPoint() != null ? new ArrayRealVector(this.getStartPoint()) : new ArrayRealVector(this.getObj().dim());
        ArrayRealVector y = new ArrayRealVector(me + mi, 0.0);
        ArrayRealVector r = new ArrayRealVector(me + mi, 1.0);
        ArrayList<Double> oldPenalty = new ArrayList<Double>();
        double functionEval = this.getObj().value((RealVector)x);
        this.functionGradient = this.getObj().gradient((RealVector)x);
        double maxGrad = this.functionGradient.getLInfNorm();
        if (this.getEqConstraint() != null) {
            this.equalityEval = this.getEqConstraint().value((RealVector)x);
        }
        if (this.getIqConstraint() != null) {
            this.inequalityEval = this.getIqConstraint().value((RealVector)x);
        }
        this.constraintJacob = this.computeJacobianConstraint((RealVector)x);
        if (this.getEqConstraint() != null) {
            maxGrad = FastMath.max((double)maxGrad, (double)this.equalityEval.getLInfNorm());
        }
        if (this.getIqConstraint() != null) {
            maxGrad = FastMath.max((double)maxGrad, (double)this.inequalityEval.getLInfNorm());
        }
        this.hessian = !this.getSettings().useFunHessian() ? MatrixUtils.createRealIdentityMatrix((int)x.getDimension()) : this.getObj().hessian((RealVector)x);
        for (int i = 0; i < this.getMaxIterations(); ++i) {
            int search;
            RealVector dy;
            RealVector dx;
            this.iterations.increment();
            double alpha = 1.0;
            LagrangeSolution sol1 = null;
            int qpLoop = 0;
            double sigma = maxGrad;
            while (sigma > this.getSettings().getSigmaMax() && qpLoop < this.getSettings().getQpMaxLoop()) {
                sol1 = this.solveQP((RealVector)x, (RealVector)y, rho);
                sigma = sol1.getValue();
                if (!(sigma > this.getSettings().getSigmaMax())) continue;
                rho = this.getSettings().getRhoCons() * rho;
                ++qpLoop;
            }
            if (qpLoop == this.getSettings().getQpMaxLoop()) {
                dx = MatrixUtils.inverse((RealMatrix)this.hessian).operate(this.penaltyFunctionGradX(this.functionGradient, (RealVector)x, (RealVector)y, (RealVector)r)).mapMultiply(-1.0);
                dy = y.subtract(this.penaltyFunctionGradY((RealVector)x, (RealVector)y, (RealVector)r));
                sigma = 0.0;
            } else {
                dx = sol1.getX();
                sigma = sol1.getValue();
                if (sigma < 0.0) {
                    sigma = 0.0;
                }
                dy = sol1.getLambda();
                r = this.updateRj(this.hessian, (RealVector)y, dx, dy, (RealVector)r, sigma);
            }
            double currentPenaltyGrad = this.penaltyFunctionGrad(this.functionGradient, dx, dy, (RealVector)x, (RealVector)y, (RealVector)r);
            rho = this.updateRho(dx, dy, this.hessian, this.constraintJacob, sigma);
            double currentPenalty = this.penaltyFunction(functionEval, 0.0, (RealVector)x, (RealVector)y, dx, dy.subtract((RealVector)y), (RealVector)r);
            double alphaF = this.getObj().value(x.add(dx.mapMultiply(alpha)));
            double alfaPenalty = this.penaltyFunction(alphaF, alpha, (RealVector)x, (RealVector)y, dx, dy.subtract((RealVector)y), (RealVector)r);
            for (search = 0; alfaPenalty - currentPenalty >= this.getSettings().getMu() * alpha * currentPenaltyGrad && search < this.getSettings().getMaxLineSearchIteration(); ++search) {
                double alfaStar = -0.5 * alpha * alpha * currentPenaltyGrad / (-alpha * currentPenaltyGrad + alfaPenalty - currentPenalty);
                alpha = FastMath.max((double)(this.getSettings().getB() * alpha), (double)FastMath.min((double)1.0, (double)alfaStar));
                alphaF = this.getObj().value(x.add(dx.mapMultiply(alpha)));
                alfaPenalty = this.penaltyFunction(alphaF, alpha, (RealVector)x, (RealVector)y, dx, dy.subtract((RealVector)y), (RealVector)r);
            }
            if (this.getSettings().getConvCriteria() != 0 ? alpha * dx.getNorm() < this.getSettings().getEps() * (1.0 + x.getNorm()) : dx.mapMultiply(alpha).dotProduct(this.hessian.operate(dx.mapMultiply(alpha))) < this.getSettings().getEps() * this.getSettings().getEps()) break;
            if (search == this.getSettings().getMaxLineSearchIteration()) {
                ++failedSearch;
            }
            boolean notMonotone = false;
            if (search == this.getSettings().getMaxLineSearchIteration()) {
                alpha = 1.0;
                search = 0;
                Double max = (Double)Collections.max(oldPenalty);
                if (oldPenalty.size() == 1) {
                    max = max * 1.3;
                }
                while (alfaPenalty - max >= this.getSettings().getMu() * alpha * currentPenaltyGrad && search < this.getSettings().getMaxLineSearchIteration()) {
                    double alfaStar = -0.5 * alpha * alpha * currentPenaltyGrad / (-alpha * currentPenaltyGrad + alfaPenalty - currentPenalty);
                    alpha = FastMath.max((double)(this.getSettings().getB() * alpha), (double)FastMath.min((double)1.0, (double)alfaStar));
                    alphaF = this.getObj().value(x.add(dx.mapMultiply(alpha)));
                    alfaPenalty = this.penaltyFunction(alphaF, alpha, (RealVector)x, (RealVector)y, dx, dy.subtract((RealVector)y), (RealVector)r);
                    ++search;
                }
                notMonotone = true;
            }
            RealVector oldGradient = this.functionGradient;
            RealMatrix oldJacob = this.constraintJacob;
            RealVector old1 = this.lagrangianGradX(oldGradient, oldJacob, (RealVector)x, y.add(dy.subtract((RealVector)y).mapMultiply(alpha)));
            functionEval = alphaF;
            this.functionGradient = this.getObj().gradient(x.add(dx.mapMultiply(alpha)));
            if (this.getEqConstraint() != null) {
                this.equalityEval = this.getEqConstraint().value(x.add(dx.mapMultiply(alpha)));
            }
            if (this.getIqConstraint() != null) {
                this.inequalityEval = this.getIqConstraint().value(x.add(dx.mapMultiply(alpha)));
            }
            this.constraintJacob = this.computeJacobianConstraint(x.add(dx.mapMultiply(alpha)));
            RealVector new1 = this.lagrangianGradX(this.functionGradient, this.constraintJacob, x.add(dx.mapMultiply(alpha)), y.add(dy.subtract((RealVector)y).mapMultiply(alpha)));
            if (failedSearch == 2) {
                this.hessian = MatrixUtils.createRealIdentityMatrix((int)x.getDimension());
                failedSearch = 0;
            }
            if (!notMonotone) {
                this.hessian = this.BFGSFormula(this.hessian, dx, alpha, new1, old1);
            }
            oldPenalty.add(currentPenalty);
            if (oldPenalty.size() > 10) {
                oldPenalty.remove(0);
            }
            x = x.add(dx.mapMultiply(alpha));
            y = y.add(dy.subtract((RealVector)y).mapMultiply(alpha));
        }
        return new LagrangeSolution((RealVector)x, (RealVector)y, functionEval);
    }

    private double penaltyFunction(double currentF, double alfa, RealVector x, RealVector y, RealVector dx, RealVector uv, RealVector r) {
        int me = 0;
        double partial = currentF;
        RealVector yalfa = y.add(uv.mapMultiply(alfa));
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
            RealVector re = r.getSubVector(0, me);
            RealVector ye = yalfa.getSubVector(0, me);
            RealVector g = this.getEqConstraint().value(x.add(dx.mapMultiply(alfa))).subtract(this.getEqConstraint().getLowerBound());
            RealVector g2 = g.ebeMultiply(g);
            partial -= ye.dotProduct(g) - 0.5 * re.dotProduct(g2);
        }
        if (this.getIqConstraint() != null) {
            int mi = this.getIqConstraint().dimY();
            RealVector ri = r.getSubVector(me, mi);
            RealVector yi = yalfa.getSubVector(me, mi);
            RealVector yk = y.getSubVector(me, mi);
            RealVector gk = this.inequalityEval.subtract(this.getIqConstraint().getLowerBound());
            RealVector g = this.getIqConstraint().value(x.add(dx.mapMultiply(alfa))).subtract(this.getIqConstraint().getLowerBound());
            ArrayRealVector mask = new ArrayRealVector(g.getDimension(), 1.0);
            for (int i = 0; i < gk.getDimension(); ++i) {
                if (!(gk.getEntry(i) > yk.getEntry(i) / ri.getEntry(i))) continue;
                mask.setEntry(i, 0.0);
                partial -= 0.5 * yi.getEntry(i) * yi.getEntry(i) / ri.getEntry(i);
            }
            RealVector g2 = g.ebeMultiply(g.ebeMultiply((RealVector)mask));
            partial -= yi.dotProduct(g.ebeMultiply((RealVector)mask)) - 0.5 * ri.dotProduct(g2);
        }
        return partial;
    }

    private double penaltyFunctionGrad(RealVector currentGrad, RealVector dx, RealVector dy, RealVector x, RealVector y, RealVector r) {
        RealMatrix jacob;
        int me = 0;
        double partial = currentGrad.dotProduct(dx);
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
            RealVector re = r.getSubVector(0, me);
            RealVector ye = y.getSubVector(0, me);
            RealVector dye = dy.getSubVector(0, me);
            RealVector ge = this.getEqConstraint().value(x).subtract(this.getEqConstraint().getLowerBound());
            jacob = this.getEqConstraint().jacobian(x);
            RealVector firstTerm = jacob.transpose().operate(ye);
            RealVector secondTerm = jacob.transpose().operate(ge.ebeMultiply(re));
            partial += -firstTerm.dotProduct(dx) + secondTerm.dotProduct(dx) - ge.dotProduct(dye.subtract(ye));
        }
        if (this.getIqConstraint() != null) {
            int mi = this.getIqConstraint().dimY();
            RealVector ri = r.getSubVector(me, mi);
            RealVector dyi = dy.getSubVector(me, mi);
            RealVector yi = y.getSubVector(me, mi);
            RealVector gi = this.getIqConstraint().value(x).subtract(this.getIqConstraint().getLowerBound());
            jacob = this.getIqConstraint().jacobian(x);
            ArrayRealVector mask = new ArrayRealVector(mi, 1.0);
            ArrayRealVector viri = new ArrayRealVector(mi, 0.0);
            for (int i = 0; i < gi.getDimension(); ++i) {
                if (gi.getEntry(i) > yi.getEntry(i) / ri.getEntry(i)) {
                    mask.setEntry(i, 0.0);
                    continue;
                }
                viri.setEntry(i, yi.getEntry(i) / ri.getEntry(i));
            }
            RealVector firstTerm = jacob.transpose().operate(yi.ebeMultiply((RealVector)mask));
            RealVector secondTerm = jacob.transpose().operate(gi.ebeMultiply(ri.ebeMultiply((RealVector)mask)));
            partial -= firstTerm.dotProduct(dx) - secondTerm.dotProduct(dx) + gi.ebeMultiply((RealVector)mask).dotProduct(dyi.subtract(yi)) + viri.dotProduct(dyi.subtract(yi));
        }
        return partial;
    }

    private RealVector penaltyFunctionGradX(RealVector currentGrad, RealVector x, RealVector y, RealVector r) {
        RealMatrix jacob;
        int me = 0;
        RealVector partial = currentGrad.copy();
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
            RealVector re = r.getSubVector(0, me);
            RealVector ye = y.getSubVector(0, me);
            RealVector ge = this.getEqConstraint().value(x).subtract(this.getEqConstraint().getLowerBound());
            jacob = this.getEqConstraint().jacobian(x);
            RealVector firstTerm = jacob.transpose().operate(ye);
            RealVector secondTerm = jacob.transpose().operate(ge.ebeMultiply(re));
            partial = partial.subtract(firstTerm.subtract(secondTerm));
        }
        if (this.getIqConstraint() != null) {
            int mi = this.getIqConstraint().dimY();
            RealVector ri = r.getSubVector(me, mi);
            RealVector yi = y.getSubVector(me, mi);
            RealVector gi = this.getIqConstraint().value(x).subtract(this.getIqConstraint().getLowerBound());
            jacob = this.getIqConstraint().jacobian(x);
            ArrayRealVector mask = new ArrayRealVector(mi, 1.0);
            for (int i = 0; i < gi.getDimension(); ++i) {
                if (!(gi.getEntry(i) > yi.getEntry(i) / ri.getEntry(i))) continue;
                mask.setEntry(i, 0.0);
            }
            RealVector firstTerm = jacob.transpose().operate(yi.ebeMultiply((RealVector)mask));
            RealVector secondTerm = jacob.transpose().operate(gi.ebeMultiply(ri.ebeMultiply((RealVector)mask)));
            partial = partial.subtract(firstTerm.subtract(secondTerm));
        }
        return partial;
    }

    private RealVector penaltyFunctionGradY(RealVector x, RealVector y, RealVector r) {
        int me = 0;
        ArrayRealVector partial = new ArrayRealVector(y.getDimension());
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
            RealVector g = this.getEqConstraint().value(x).subtract(this.getEqConstraint().getLowerBound());
            partial.setSubVector(0, g.mapMultiply(-1.0));
        }
        if (this.getIqConstraint() != null) {
            int mi = this.getIqConstraint().dimY();
            RealVector ri = r.getSubVector(me, mi);
            RealVector yi = y.getSubVector(me, mi);
            RealVector gi = this.getIqConstraint().value(x).subtract(this.getIqConstraint().getLowerBound());
            ArrayRealVector mask = new ArrayRealVector(mi, 1.0);
            ArrayRealVector viri = new ArrayRealVector(mi, 0.0);
            for (int i = 0; i < gi.getDimension(); ++i) {
                if (gi.getEntry(i) > yi.getEntry(i) / ri.getEntry(i)) {
                    mask.setEntry(i, 0.0);
                    continue;
                }
                viri.setEntry(i, yi.getEntry(i) / ri.getEntry(i));
            }
            partial.setSubVector(me, gi.ebeMultiply((RealVector)mask).add((RealVector)viri).mapMultiply(-1.0));
        }
        return partial;
    }

    private RealVector updateRj(RealMatrix H, RealVector y, RealVector dx, RealVector dy, RealVector r, double additional) {
        int i;
        ArrayRealVector sigma = new ArrayRealVector(r.getDimension());
        for (int i2 = 0; i2 < sigma.getDimension(); ++i2) {
            double appoggio = (double)this.iterations.getCount() / FastMath.sqrt((double)r.getEntry(i2));
            sigma.setEntry(i2, FastMath.min((double)1.0, (double)appoggio));
        }
        int me = 0;
        int mi = 0;
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
        }
        if (this.getIqConstraint() != null) {
            mi = this.getIqConstraint().dimY();
        }
        RealVector sigmar = sigma.ebeMultiply(r);
        RealVector numerator = dy.subtract(y).ebeMultiply(dy.subtract(y)).mapMultiply(2.0 * (double)(mi + me));
        double denominator = dx.dotProduct(H.operate(dx)) * (1.0 - additional);
        RealVector r1 = r.copy();
        if (this.getEqConstraint() != null) {
            for (i = 0; i < me; ++i) {
                r1.setEntry(i, FastMath.max((double)sigmar.getEntry(i), (double)(numerator.getEntry(i) / denominator)));
            }
        }
        if (this.getIqConstraint() != null) {
            for (i = 0; i < mi; ++i) {
                r1.setEntry(me + i, FastMath.max((double)sigmar.getEntry(me + i), (double)(numerator.getEntry(me + i) / denominator)));
            }
        }
        return r1;
    }

    private double updateRho(RealVector dx, RealVector dy, RealMatrix H, RealMatrix jacobianG, double additionalVariable) {
        double num = 10.0 * FastMath.pow((double)dx.dotProduct(jacobianG.transpose().operate(dy)), (int)2);
        double den = (1.0 - additionalVariable) * (1.0 - additionalVariable) * dx.dotProduct(H.operate(dx));
        return FastMath.max((double)10.0, (double)(num / den));
    }

    private LagrangeSolution solveQP(RealVector x, RealVector y, double rho) {
        RealMatrix H = this.hessian;
        RealVector g = this.functionGradient;
        int me = 0;
        int mi = 0;
        int add = 0;
        boolean violated = false;
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
        }
        if (this.getIqConstraint() != null) {
            mi = this.getIqConstraint().dimY();
            boolean bl = violated = this.inequalityEval.subtract(this.getIqConstraint().getLowerBound()).getMinValue() <= this.getSettings().getEps() || y.getMaxValue() >= 0.0;
        }
        if (me > 0 || violated) {
            add = 1;
        }
        Array2DRowRealMatrix H1 = new Array2DRowRealMatrix(H.getRowDimension() + add, H.getRowDimension() + add);
        H1.setSubMatrix(H.getData(), 0, 0);
        if (add == 1) {
            H1.setEntry(H.getRowDimension(), H.getRowDimension(), rho);
        }
        ArrayRealVector g1 = new ArrayRealVector(g.getDimension() + add);
        g1.setSubVector(0, g);
        LinearEqualityConstraint eqc = null;
        if (this.getEqConstraint() != null) {
            RealMatrix eqJacob = this.constraintJacob.getSubMatrix(0, me - 1, 0, x.getDimension() - 1);
            Array2DRowRealMatrix Ae = new Array2DRowRealMatrix(me, x.getDimension() + add);
            ArrayRealVector be = new ArrayRealVector(me);
            Ae.setSubMatrix(eqJacob.getData(), 0, 0);
            RealVector conditioneq = this.equalityEval.subtract(this.getEqConstraint().getLowerBound());
            Ae.setColumnVector(x.getDimension(), conditioneq.mapMultiply(-1.0));
            be.setSubVector(0, this.getEqConstraint().getLowerBound().subtract(this.equalityEval));
            eqc = new LinearEqualityConstraint((RealMatrix)Ae, (RealVector)be);
        }
        LinearInequalityConstraint iqc = null;
        if (this.getIqConstraint() != null) {
            RealMatrix iqJacob = this.constraintJacob.getSubMatrix(me, me + mi - 1, 0, x.getDimension() - 1);
            Array2DRowRealMatrix Ai = new Array2DRowRealMatrix(mi, x.getDimension() + add);
            ArrayRealVector bi = new ArrayRealVector(mi);
            Ai.setSubMatrix(iqJacob.getData(), 0, 0);
            RealVector conditioniq = this.inequalityEval.subtract(this.getIqConstraint().getLowerBound());
            if (add == 1) {
                for (int i = 0; i < conditioniq.getDimension(); ++i) {
                    if (conditioniq.getEntry(i) <= this.getSettings().getEps() || y.getEntry(me + i) > 0.0) continue;
                    conditioniq.setEntry(i, 0.0);
                }
                Ai.setColumnVector(x.getDimension(), conditioniq.mapMultiply(-1.0));
            }
            bi.setSubVector(0, this.getIqConstraint().getLowerBound().subtract(this.inequalityEval));
            iqc = new LinearInequalityConstraint((RealMatrix)Ai, (RealVector)bi);
        }
        LinearBoundedConstraint bc = null;
        if (add == 1) {
            Array2DRowRealMatrix sigmaA = new Array2DRowRealMatrix(1, x.getDimension() + 1);
            sigmaA.setEntry(0, x.getDimension(), 1.0);
            ArrayRealVector lb = new ArrayRealVector(1, 0.0);
            ArrayRealVector ub = new ArrayRealVector(1, 1.0);
            bc = new LinearBoundedConstraint((RealMatrix)sigmaA, (RealVector)lb, (RealVector)ub);
        }
        QuadraticFunction q = new QuadraticFunction((RealMatrix)H1, (RealVector)g1, 0.0);
        ADMMQPOptimizer solver = new ADMMQPOptimizer();
        LagrangeSolution sol = solver.optimize(new ObjectiveFunction(q), iqc, eqc, bc);
        double sigma = add == 1 ? sol.getX().getEntry(x.getDimension()) : 0.0;
        return new LagrangeSolution(sol.getX().getSubVector(0, x.getDimension()), sol.getLambda().getSubVector(0, me + mi), sigma);
    }

    private RealMatrix computeJacobianConstraint(RealVector x) {
        int me = 0;
        int mi = 0;
        RealMatrix je = null;
        RealMatrix ji = null;
        if (this.getEqConstraint() != null) {
            me = this.getEqConstraint().dimY();
            je = this.getEqConstraint().jacobian(x);
        }
        if (this.getIqConstraint() != null) {
            mi = this.getIqConstraint().dimY();
            ji = this.getIqConstraint().jacobian(x);
        }
        Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(me + mi, x.getDimension());
        if (me > 0) {
            jacobian.setSubMatrix(je.getData(), 0, 0);
        }
        if (mi > 0) {
            jacobian.setSubMatrix(ji.getData(), me, 0);
        }
        return jacobian;
    }

    private RealMatrix BFGSFormula(RealMatrix oldH, RealVector dx, double alfa, RealVector newGrad, RealVector oldGrad) {
        RealMatrix oldH1 = oldH.copy();
        RealVector y1 = newGrad.subtract(oldGrad);
        RealVector s = dx.mapMultiply(alfa);
        double theta = 1.0;
        if (s.dotProduct(y1) < 0.2 * s.dotProduct(oldH.operate(s))) {
            theta = 0.8 * s.dotProduct(oldH.operate(s)) / (s.dotProduct(oldH.operate(s)) - s.dotProduct(y1));
        }
        RealVector y = y1.mapMultiply(theta).add(oldH.operate(s).mapMultiply(1.0 - theta));
        RealMatrix firstTerm = y.outerProduct(y).scalarMultiply(1.0 / s.dotProduct(y));
        RealMatrix secondTerm = oldH1.multiply(s.outerProduct(s)).multiply(oldH);
        double thirtTerm = s.dotProduct(oldH1.operate(s));
        RealMatrix Hnew = oldH1.add(firstTerm).subtract(secondTerm.scalarMultiply(1.0 / thirtTerm));
        EigenDecompositionSymmetric dsX = new EigenDecompositionSymmetric(Hnew);
        double min = new ArrayRealVector(dsX.getEigenvalues()).getMinValue();
        if (min < 0.0) {
            Hnew = MatrixUtils.createRealIdentityMatrix((int)oldH.getRowDimension());
        }
        return Hnew;
    }
}

