/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.constrained;

import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.OptimizationData;
import org.hipparchus.optim.nonlinear.vector.constrained.InequalityConstraint;
import org.hipparchus.util.MathUtils;

public class LinearInequalityConstraint
extends InequalityConstraint
implements OptimizationData {
    private final RealMatrix a;

    public LinearInequalityConstraint(RealMatrix a, RealVector b) {
        super(b);
        MathUtils.checkDimension((int)b.getDimension(), (int)a.getRowDimension());
        this.a = a;
    }

    public LinearInequalityConstraint(double[][] a, double[] b) {
        this(MatrixUtils.createRealMatrix((double[][])a), MatrixUtils.createRealVector((double[])b));
    }

    @Override
    public int dim() {
        return this.a.getColumnDimension();
    }

    @Override
    public RealVector value(RealVector x) {
        return this.a.operate(x);
    }

    @Override
    public RealMatrix jacobian(RealVector x) {
        return this.a.copy();
    }
}

