/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff.interpolators;

import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.interpolators.RungeKuttaStateInterpolator;

public class DormandPrince853StateInterpolator
extends RungeKuttaStateInterpolator {
    private static final long serialVersionUID = 20160328L;
    private static final double[][] D = new double[][]{{0.054293734116568765, 0.0, 0.0, 0.0, 0.0, 4.450312892752409, 1.8915178993145003, -5.801203960010585, 0.3111643669578199, -0.1521609496625161, 0.20136540080403034, 0.04471061572777259, 0.0, 0.0, 0.0, 0.0}, {0.9457062658834312, 0.0, 0.0, 0.0, 0.0, -4.450312892752409, -1.8915178993145003, 5.801203960010585, -0.3111643669578199, 0.1521609496625161, -0.20136540080403034, -0.04471061572777259, 0.0, 0.0, 0.0, 0.0}, {-0.8914125317668625, 0.0, 0.0, 0.0, 0.0, 8.900625785504818, 3.7830357986290006, -11.60240792002117, 0.6223287339156398, -0.3043218993250322, 0.4027308016080607, 0.08942123145554517, -1.0, 0.0, 0.0, 0.0}, {-8.428938276109013, 0.0, 0.0, 0.0, 0.0, 0.5667149535193777, -3.0689499459498917, 2.38466765651207, 2.1170345824450285, -0.871391583777973, 2.2404374302607883, 0.6315787787694688, -0.08899033645133331, 18.148505520854727, -9.194632392478356, -4.436036387594894}, {10.427508642579134, 0.0, 0.0, 0.0, 0.0, 242.28349177525817, 165.20045171727028, -374.5467547226902, -22.113666853125302, 7.733432668472264, -30.674084731089398, -9.332130526430229, 15.697238121770845, -31.139403219565178, -9.35292435884448, 35.81684148639408}, {19.985053242002433, 0.0, 0.0, 0.0, 0.0, -387.0373087493518, -189.17813819516758, 527.8081592054236, -11.573902539959631, 6.8812326946963, -1.0006050966910838, 0.7777137798053443, -2.778205752353508, -60.19669523126412, 84.32040550667716, 11.99229113618279}, {-25.69393346270375, 0.0, 0.0, 0.0, 0.0, -154.18974869023643, -231.5293791760455, 357.6391179106141, 93.4053241836243, -37.45832313645163, 104.0996495089623, 29.8402934266605, -43.53345659001114, 96.32455395918828, -39.17726167561544, -149.72683625798564}};

    public DormandPrince853StateInterpolator(boolean forward, double[][] yDotK, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper mapper) {
        super(forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected DormandPrince853StateInterpolator create(boolean newForward, double[][] newYDotK, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new DormandPrince853StateInterpolator(newForward, newYDotK, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper mapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        double[] interpolatedDerivatives;
        double[] interpolatedState;
        double eta = 1.0 - theta;
        double twoTheta = 2.0 * theta;
        double theta2 = theta * theta;
        double dot1 = 1.0 - twoTheta;
        double dot2 = theta * (2.0 - 3.0 * theta);
        double dot3 = twoTheta * (theta * (twoTheta - 3.0) + 1.0);
        double dot4 = theta2 * (theta * (5.0 * theta - 8.0) + 3.0);
        double dot5 = theta2 * (theta * (theta * (15.0 - 6.0 * theta) - 12.0) + 3.0);
        double dot6 = theta2 * (theta * (theta * (theta * (18.0 - 7.0 * theta) - 15.0) + 4.0));
        if (this.getGlobalPreviousState() != null && theta <= 0.5) {
            double f0 = thetaH;
            double f1 = f0 * eta;
            double f2 = f1 * theta;
            double f3 = f2 * eta;
            double f4 = f3 * theta;
            double f5 = f4 * eta;
            double f6 = f5 * theta;
            double[] p = new double[16];
            double[] q = new double[16];
            for (int i = 0; i < p.length; ++i) {
                p[i] = f0 * D[0][i] + f1 * D[1][i] + f2 * D[2][i] + f3 * D[3][i] + f4 * D[4][i] + f5 * D[5][i] + f6 * D[6][i];
                q[i] = D[0][i] + dot1 * D[1][i] + dot2 * D[2][i] + dot3 * D[3][i] + dot4 * D[4][i] + dot5 * D[5][i] + dot6 * D[6][i];
            }
            interpolatedState = this.previousStateLinearCombination(p[0], p[1], p[2], p[3], p[4], p[5], p[6], p[7], p[8], p[9], p[10], p[11], p[12], p[13], p[14], p[15]);
            interpolatedDerivatives = this.derivativeLinearCombination(q[0], q[1], q[2], q[3], q[4], q[5], q[6], q[7], q[8], q[9], q[10], q[11], q[12], q[13], q[14], q[15]);
        } else {
            double f0 = -oneMinusThetaH;
            double f1 = -f0 * theta;
            double f2 = f1 * theta;
            double f3 = f2 * eta;
            double f4 = f3 * theta;
            double f5 = f4 * eta;
            double f6 = f5 * theta;
            double[] p = new double[16];
            double[] q = new double[16];
            for (int i = 0; i < p.length; ++i) {
                p[i] = f0 * D[0][i] + f1 * D[1][i] + f2 * D[2][i] + f3 * D[3][i] + f4 * D[4][i] + f5 * D[5][i] + f6 * D[6][i];
                q[i] = D[0][i] + dot1 * D[1][i] + dot2 * D[2][i] + dot3 * D[3][i] + dot4 * D[4][i] + dot5 * D[5][i] + dot6 * D[6][i];
            }
            interpolatedState = this.currentStateLinearCombination(p[0], p[1], p[2], p[3], p[4], p[5], p[6], p[7], p[8], p[9], p[10], p[11], p[12], p[13], p[14], p[15]);
            interpolatedDerivatives = this.derivativeLinearCombination(q[0], q[1], q[2], q[3], q[4], q[5], q[6], q[7], q[8], q[9], q[10], q[11], q[12], q[13], q[14], q[15]);
        }
        return mapper.mapStateAndDerivative(time, interpolatedState, interpolatedDerivatives);
    }
}

